/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.CheckFormObject;
import org.openforis.idm.metamodel.validation.ComparisonCheck;

public class ComparisonCheckFormObject
extends CheckFormObject<ComparisonCheck> {
    private String greaterThan;
    private String lessThan;
    private GreaterThanType greaterThanType;
    private LessThanType lessThanType;

    @Override
    public void saveTo(ComparisonCheck dest, String languageCode) {
        super.saveTo(dest, languageCode);
        this.resetExpressions(dest);
        String trimmedGreaterThanExpr = StringUtils.trimToNull((String)this.greaterThan);
        String trimmedLessThanExpr = StringUtils.trimToNull((String)this.lessThan);
        if (trimmedGreaterThanExpr != null && trimmedLessThanExpr != null && this.greaterThanType == GreaterThanType.GE && this.lessThanType == LessThanType.LE && trimmedGreaterThanExpr.equals(trimmedLessThanExpr)) {
            dest.setEqualsExpression(trimmedGreaterThanExpr);
        } else {
            if (trimmedGreaterThanExpr != null) {
                if (this.greaterThanType == GreaterThanType.GE) {
                    dest.setGreaterThanOrEqualsExpression(trimmedGreaterThanExpr);
                } else {
                    dest.setGreaterThanExpression(trimmedGreaterThanExpr);
                }
            }
            if (trimmedLessThanExpr != null) {
                if (this.lessThanType == LessThanType.LE) {
                    dest.setLessThanOrEqualsExpression(trimmedLessThanExpr);
                } else {
                    dest.setLessThanExpression(trimmedLessThanExpr);
                }
            }
        }
    }

    @Override
    public void loadFrom(ComparisonCheck source, String languageCode) {
        super.loadFrom(source, languageCode);
        if (StringUtils.isNotBlank((CharSequence)source.getEqualsExpression())) {
            this.greaterThan = this.lessThan = source.getEqualsExpression();
            this.greaterThanType = GreaterThanType.GE;
            this.lessThanType = LessThanType.LE;
        } else {
            if (StringUtils.isNotBlank((CharSequence)source.getGreaterThanExpression())) {
                this.greaterThan = source.getGreaterThanExpression();
                this.greaterThanType = GreaterThanType.GT;
            } else if (StringUtils.isNotBlank((CharSequence)source.getGreaterThanOrEqualsExpression())) {
                this.greaterThan = source.getGreaterThanOrEqualsExpression();
                this.greaterThanType = GreaterThanType.GE;
            }
            if (StringUtils.isNotBlank((CharSequence)source.getLessThanExpression())) {
                this.lessThan = source.getLessThanExpression();
                this.lessThanType = LessThanType.LT;
            } else if (StringUtils.isNotBlank((CharSequence)source.getLessThanOrEqualsExpression())) {
                this.lessThan = source.getLessThanOrEqualsExpression();
                this.lessThanType = LessThanType.LE;
            }
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.lessThan = null;
        this.greaterThan = null;
        this.greaterThanType = GreaterThanType.GT;
        this.lessThanType = LessThanType.LT;
    }

    protected void resetExpressions(ComparisonCheck dest) {
        dest.setEqualsExpression(null);
        dest.setGreaterThanExpression(null);
        dest.setGreaterThanOrEqualsExpression(null);
        dest.setLessThanExpression(null);
        dest.setLessThanOrEqualsExpression(null);
    }

    public String getGreaterThan() {
        return this.greaterThan;
    }

    public void setGreaterThan(String greaterThan) {
        this.greaterThan = greaterThan;
    }

    public String getGreaterThanTypeCode() {
        return this.greaterThanType.name();
    }

    public void setGreaterThanTypeCode(String value) {
        this.greaterThanType = GreaterThanType.valueOf(value);
    }

    public String getLessThan() {
        return this.lessThan;
    }

    public void setLessThan(String lessThan) {
        this.lessThan = lessThan;
    }

    public String getLessThanTypeCode() {
        return this.lessThanType.name();
    }

    public void setLessThanTypeCode(String value) {
        this.lessThanType = LessThanType.valueOf(value);
    }

    private static enum GreaterThanType {
        GT,
        GE;

    }

    private static enum LessThanType {
        LT,
        LE;

    }
}

