/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openforis.collect.designer.metamodel.AttributeTypeUtils;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.io.excel.ExcelFlatValuesWriter;
import org.openforis.commons.io.flat.FlatDataWriter;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Task;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeDefinitionVisitor;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.validation.Check;

public class SchemaSummaryCSVExportJob
extends Job {
    private CollectSurvey survey;
    private boolean onlyLabels;
    private File outputFile;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.outputFile = File.createTempFile("collect_schema_export", ".csv");
    }

    protected void buildTasks() throws Throwable {
        Task task = new Task(){

            protected void execute() throws Throwable {
                try (FileOutputStream out = new FileOutputStream(SchemaSummaryCSVExportJob.this.outputFile);
                     ExcelFlatValuesWriter csvWriter = new ExcelFlatValuesWriter((OutputStream)out);){
                    SchemaSummaryCSVExportJob.this.writeHeaders((FlatDataWriter)csvWriter);
                    Schema schema = SchemaSummaryCSVExportJob.this.survey.getSchema();
                    schema.traverse(new NodeDefinitionVisitor((FlatDataWriter)csvWriter){
                        final /* synthetic */ FlatDataWriter val$csvWriter;
                        {
                            this.val$csvWriter = flatDataWriter;
                        }

                        public void visit(NodeDefinition nodeDefn) {
                            ArrayList<String> values = new ArrayList<String>();
                            values.add(Integer.toString(nodeDefn.getId()));
                            if (!SchemaSummaryCSVExportJob.this.onlyLabels) {
                                values.addAll(Arrays.asList(nodeDefn.getPath(), nodeDefn instanceof EntityDefinition ? "entity" : "attribute", nodeDefn instanceof AttributeDefinition ? AttributeTypeUtils.getLabel((AttributeDefinition)nodeDefn) : ""));
                            }
                            for (String lang : SchemaSummaryCSVExportJob.this.survey.getLanguages()) {
                                values.add(nodeDefn.getLabel(NodeLabel.Type.INSTANCE, lang));
                            }
                            for (String lang : SchemaSummaryCSVExportJob.this.survey.getLanguages()) {
                                values.add(nodeDefn.getDescription(lang));
                            }
                            for (String lang : SchemaSummaryCSVExportJob.this.survey.getLanguages()) {
                                values.add(nodeDefn.getLabel(NodeLabel.Type.REPORTING, lang));
                            }
                            if (!SchemaSummaryCSVExportJob.this.onlyLabels) {
                                values.addAll(Arrays.asList(String.valueOf(nodeDefn.isAlwaysRelevant()), nodeDefn.isAlwaysRelevant() ? "" : nodeDefn.getRelevantExpression(), String.valueOf(nodeDefn.isAlwaysRequired()), nodeDefn.isAlwaysRequired() ? "" : nodeDefn.extractRequiredExpression(), SchemaSummaryCSVExportJob.this.extractValidationRules(nodeDefn)));
                            }
                            this.val$csvWriter.writeNext(values);
                        }
                    });
                }
            }
        };
        this.addTask((Worker)task);
    }

    private void writeHeaders(FlatDataWriter valuesWriter) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("id");
        if (!this.onlyLabels) {
            headers.addAll(Arrays.asList("path", "type", "attribute_type"));
        }
        for (String lang : this.survey.getLanguages()) {
            headers.add("label_" + lang);
        }
        for (String lang : this.survey.getLanguages()) {
            headers.add("description_" + lang);
        }
        for (String lang : this.survey.getLanguages()) {
            headers.add("label_reporting_" + lang);
        }
        if (!this.onlyLabels) {
            headers.addAll(Arrays.asList("always_relevant", "relevant_when", "always_required", "required_when", "validation_rules"));
        }
        valuesWriter.writeHeaders(headers);
    }

    private String extractValidationRules(NodeDefinition nodeDefn) {
        if (!(nodeDefn instanceof AttributeDefinition)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        List checks = ((AttributeDefinition)nodeDefn).getChecks();
        for (int i = 0; i < checks.size(); ++i) {
            Check check = (Check)checks.get(i);
            sb.append(check.toString());
            if (i >= checks.size() - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public void setOnlyLabels(boolean onlyLabels) {
        this.onlyLabels = onlyLabels;
    }

    public File getOutputFile() {
        return this.outputFile;
    }
}

