/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager.dataexport.samplingdesign;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.io.metadata.samplingdesign.SamplingDesignFileColumn;
import org.openforis.collect.manager.SamplingDesignManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SamplingDesignItem;
import org.openforis.collect.model.SamplingDesignSummaries;
import org.openforis.commons.io.csv.CsvWriter;
import org.openforis.idm.metamodel.ReferenceDataSchema;

public class SamplingDesignExportProcess {
    private static final Logger LOG = LogManager.getLogger(SamplingDesignExportProcess.class);
    private SamplingDesignManager samplingDesignManager;

    public SamplingDesignExportProcess(SamplingDesignManager samplingDesignManager) {
        this.samplingDesignManager = samplingDesignManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToCSV(OutputStream out, CollectSurvey survey) {
        CsvWriter writer = null;
        try {
            writer = new CsvWriter(out);
            SamplingDesignSummaries summaries = this.samplingDesignManager.loadBySurvey(survey.getId().intValue());
            ArrayList<String> colNames = new ArrayList<String>();
            colNames.addAll(Arrays.asList(SamplingDesignFileColumn.LEVEL_COLUMN_NAMES));
            colNames.add(SamplingDesignFileColumn.X.getColumnName());
            colNames.add(SamplingDesignFileColumn.Y.getColumnName());
            colNames.add(SamplingDesignFileColumn.SRS_ID.getColumnName());
            List<ReferenceDataSchema.ReferenceDataDefinition.Attribute> infoAttributes = this.getInfoAttributes(survey);
            for (ReferenceDataSchema.ReferenceDataDefinition.Attribute attribute : infoAttributes) {
                colNames.add(attribute.getName());
            }
            writer.writeHeaders(colNames);
            List items = summaries.getRecords();
            for (SamplingDesignItem item : items) {
                this.writeSummary(writer, survey, item);
            }
        }
        catch (Exception e) {
            try {
                LOG.error((Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)writer);
        }
        IOUtils.closeQuietly((Closeable)writer);
    }

    protected void writeSummary(CsvWriter writer, CollectSurvey survey, SamplingDesignItem item) {
        ArrayList<String> lineValues = new ArrayList<String>();
        List levelCodes = item.getLevelCodes();
        SamplingDesignFileColumn[] levelColumns = SamplingDesignFileColumn.LEVEL_COLUMNS;
        for (int level = 1; level <= levelColumns.length; ++level) {
            String levelCode = level <= levelCodes.size() ? item.getLevelCode(level) : "";
            lineValues.add(levelCode);
        }
        lineValues.add(item.getX().toString());
        lineValues.add(item.getY().toString());
        lineValues.add(item.getSrsId());
        List<ReferenceDataSchema.ReferenceDataDefinition.Attribute> infoAttributes = this.getInfoAttributes(survey);
        for (int i = 0; i < infoAttributes.size(); ++i) {
            lineValues.add(item.getInfoAttribute(i));
        }
        writer.writeNext(lineValues);
    }

    private List<ReferenceDataSchema.ReferenceDataDefinition.Attribute> getInfoAttributes(CollectSurvey survey) {
        ReferenceDataSchema.SamplingPointDefinition samplingPoint;
        ReferenceDataSchema referenceDataSchema = survey.getReferenceDataSchema();
        ReferenceDataSchema.SamplingPointDefinition samplingPointDefinition = samplingPoint = referenceDataSchema == null ? null : referenceDataSchema.getSamplingPointDefinition();
        if (samplingPoint == null) {
            return Collections.emptyList();
        }
        List infoAttributes = samplingPoint.getAttributes(false);
        return infoAttributes;
    }
}

