/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openforis.collect.Proxy;
import org.openforis.collect.ProxyContext;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.User;
import org.openforis.collect.model.proxy.BasicUserProxy;
import org.openforis.collect.model.proxy.UserProxy;
import org.openforis.collect.utils.Proxies;
import org.openforis.idm.metamodel.ModelVersion;

public class RecordSummaryProxy
implements Proxy {
    private transient CollectRecordSummary summary;
    private transient ProxyContext context;

    public RecordSummaryProxy(CollectRecordSummary summary, ProxyContext context) {
        this.summary = summary;
        this.context = context;
    }

    public static List<RecordSummaryProxy> fromList(List<CollectRecordSummary> summaries, ProxyContext context) {
        ArrayList<RecordSummaryProxy> result = new ArrayList<RecordSummaryProxy>();
        if (summaries != null) {
            for (CollectRecordSummary summary : summaries) {
                result.add(new RecordSummaryProxy(summary, context));
            }
        }
        return result;
    }

    public int getSurveyId() {
        return this.summary.getSurvey().getId();
    }

    public CollectRecord.Step getStep() {
        return this.summary.getStep();
    }

    public int getStepNumber() {
        return this.summary.getStep().getStepNumber();
    }

    public CollectRecord.State getState() {
        return null;
    }

    public Date getCreationDate() {
        return this.summary.getCreationDate();
    }

    public BasicUserProxy getCreatedBy() {
        User createdBy = this.summary.getCreatedBy();
        return createdBy == null ? null : new BasicUserProxy(createdBy);
    }

    public Date getModifiedDate() {
        return this.summary.getModifiedDate();
    }

    public Integer getId() {
        return this.summary.getId();
    }

    public BasicUserProxy getModifiedBy() {
        User modifiedBy = this.summary.getModifiedBy();
        return modifiedBy == null ? null : new BasicUserProxy(modifiedBy);
    }

    public Integer getVersionId() {
        ModelVersion version = this.getVersion();
        return version == null ? null : Integer.valueOf(version.getId());
    }

    public List<String> getRootEntityKeys() {
        return this.summary.getRootEntityKeyValues();
    }

    public List<Integer> getEntityCounts() {
        return this.summary.getEntityCounts();
    }

    public boolean isEntryComplete() {
        if (this.summary.getStep() != null) {
            switch (this.summary.getStep()) {
                case ENTRY: {
                    return false;
                }
                case CLEANSING: 
                case ANALYSIS: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCleansingComplete() {
        if (this.summary.getStep() != null) {
            switch (this.summary.getStep()) {
                case ANALYSIS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public Map<CollectRecord.Step, CollectRecordSummary.StepSummary> getStepSummaries() {
        return this.summary.getStepSummaries();
    }

    public List<String> getSummaryValues() {
        return this.summary.getCurrentStepSummary().getSummaryValues();
    }

    public Integer getTotalErrors() {
        return this.summary.getCurrentStepSummary().getTotalErrors();
    }

    public Integer getErrors() {
        return this.summary.getCurrentStepSummary().getErrors();
    }

    public Integer getSkipped() {
        return this.summary.getCurrentStepSummary().getSkipped();
    }

    public Integer getMissing() {
        return this.summary.getCurrentStepSummary().getMissing();
    }

    public Integer getWarnings() {
        return this.summary.getCurrentStepSummary().getWarnings();
    }

    public Integer getMissingErrors() {
        return this.summary.getCurrentStepSummary().getMissingErrors();
    }

    public Integer getMissingWarnings() {
        return this.summary.getCurrentStepSummary().getMissingWarnings();
    }

    public UserProxy getOwner() {
        return Proxies.fromObject(this.summary.getOwner(), UserProxy.class);
    }

    public String getLockedBy() {
        return this.summary.getLockedBy();
    }

    private ModelVersion getVersion() {
        return this.summary.getVersion();
    }
}

