/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.validator;

import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.web.controller.SurveyController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class SurveyCreationParametersValidator
extends SimpleValidator<SurveyController.SurveyCreationParameters> {
    private static final String NAME_ALREADY_IN_USE_MESSAGE_KEY = "survey.validation.nameAlreadyInUse";
    private static final String NAME_FIELD = "name";
    @Autowired
    private SurveyManager surveyManager;

    @Override
    public void validateForm(SurveyController.SurveyCreationParameters parameters, Errors errors) {
        if (this.validateRequiredField(errors, NAME_FIELD) && this.validateInternalName(errors, NAME_FIELD) && this.validateMinLength(errors, NAME_FIELD, 5)) {
            this.validateSurveyNameUniqueness(parameters, errors);
        }
        this.validateRequiredFields(errors, "templateType", "defaultLanguageCode", "userGroupId");
    }

    private boolean validateSurveyNameUniqueness(SurveyController.SurveyCreationParameters parameters, Errors errors) {
        String name = parameters.getName();
        SurveySummary existingSummary = this.surveyManager.loadSummaryByName(name);
        if (existingSummary != null) {
            errors.rejectValue(NAME_FIELD, NAME_ALREADY_IN_USE_MESSAGE_KEY);
            return false;
        }
        return true;
    }
}

