/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.controller;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryResultItem;
import org.openforis.collect.datacleansing.controller.DataQueryController;
import org.openforis.commons.io.csv.CsvWriter;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.model.Value;

public class CSVWriterDataQueryResultItemProcessor
extends DataQueryController.AttributeQueryResultItemProcessor
implements Closeable {
    private File tempFile;
    private CsvWriter csvWriter;

    public CSVWriterDataQueryResultItemProcessor(DataQuery query) {
        super(query);
        this.init();
    }

    private void init() {
        try {
            this.tempFile = File.createTempFile("collect-data-cleansing-query", ".csv");
            this.csvWriter = new CsvWriter((OutputStream)new FileOutputStream(this.tempFile), "UTF-8", ',', '\"');
            this.writeCSVHeader();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeCSVHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        EntityDefinition rootEntity = this.query.getEntityDefinition().getRootEntity();
        List keyAttributeDefinitions = rootEntity.getKeyAttributeDefinitions();
        for (AttributeDefinition def : keyAttributeDefinitions) {
            String keyLabel = def.getLabel(NodeLabel.Type.INSTANCE);
            if (StringUtils.isBlank((CharSequence)keyLabel)) {
                keyLabel = def.getName();
            }
            headers.add(keyLabel);
        }
        headers.add("Path");
        AttributeDefinition attrDef = (AttributeDefinition)this.query.getSchema().getDefinitionById(this.query.getAttributeDefinitionId());
        headers.addAll(this.extractFieldHeaders(attrDef));
        this.csvWriter.writeHeaders(headers);
    }

    private List<String> extractFieldHeaders(AttributeDefinition attrDef) {
        List fieldNames = attrDef.getFieldNames();
        ArrayList<String> headers = new ArrayList<String>(fieldNames.size());
        String attrName = attrDef.getName();
        if (fieldNames.size() > 1) {
            for (String fieldName : fieldNames) {
                headers.add(attrName + "_" + fieldName);
            }
        } else {
            headers.add(attrName);
        }
        return headers;
    }

    @Override
    public void process(DataQueryResultItem item) {
        ArrayList<String> lineValues = new ArrayList<String>();
        lineValues.addAll(item.getRecordKeyValues());
        lineValues.add(item.extractNodePath());
        AttributeDefinition attrDef = item.getAttributeDefinition();
        Value value = item.extractAttributeValue();
        Map valueMap = value == null ? null : value.toMap();
        List fieldNames = attrDef.getFieldNames();
        for (String fieldName : fieldNames) {
            Object fieldValue = valueMap == null ? null : (Object)valueMap.get(fieldName);
            lineValues.add(fieldValue == null ? "" : fieldValue.toString());
        }
        this.csvWriter.writeNext(lineValues);
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }

    public File getOutputFile() {
        return this.tempFile;
    }
}

