/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.persistence;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableLike;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.DataReport;
import org.openforis.collect.datacleansing.persistence.DataCleansingItemDao;
import org.openforis.collect.datacleansing.persistence.DataQueryGroupDao;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.persistence.jooq.CollectDSLContext;
import org.openforis.collect.persistence.jooq.Sequences;
import org.openforis.collect.persistence.jooq.SurveyObjectMappingDSLContext;
import org.openforis.collect.persistence.jooq.tables.OfcDataQueryGroup;
import org.openforis.collect.persistence.jooq.tables.OfcDataReport;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dataReportDao")
@Transactional
public class DataReportDao
extends DataCleansingItemDao<DataReport, JooqDSLContext> {
    public DataReportDao() {
        super(JooqDSLContext.class);
    }

    public List<DataReport> loadBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectConditionStep select = dsl.select((SelectField[])OfcDataReport.OFC_DATA_REPORT.fields()).from((TableLike)OfcDataReport.OFC_DATA_REPORT).join((TableLike)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP).on(new Condition[]{OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.ID.eq((Field)OfcDataReport.OFC_DATA_REPORT.QUERY_GROUP_ID)}).where(new Condition[]{OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.SURVEY_ID.eq((Object)survey.getId())});
        return dsl.fromResult(select.fetch());
    }

    public void deleteBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl();
        dsl.delete((Table)OfcDataReport.OFC_DATA_REPORT).where(new Condition[]{OfcDataReport.OFC_DATA_REPORT.QUERY_GROUP_ID.in(DataQueryGroupDao.createDataQueryGroupIdBySurveyQuery((CollectDSLContext)dsl, survey))}).execute();
    }

    public List<DataReport> loadByQueryGroup(DataQueryGroup queryGroup) {
        CollectSurvey survey = (CollectSurvey)queryGroup.getSurvey();
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectConditionStep select = dsl.selectFrom((Table)OfcDataReport.OFC_DATA_REPORT).where(new Condition[]{OfcDataReport.OFC_DATA_REPORT.QUERY_GROUP_ID.eq((Object)((Integer)queryGroup.getId()))});
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    protected static SelectConditionStep<Record1<Integer>> createDataReportIdsBySurveyQuery(CollectDSLContext dsl, CollectSurvey survey) {
        return dsl.select((SelectField)OfcDataReport.OFC_DATA_REPORT.ID).from((TableLike)OfcDataReport.OFC_DATA_REPORT).where(new Condition[]{OfcDataReport.OFC_DATA_REPORT.QUERY_GROUP_ID.in(DataQueryGroupDao.createDataQueryGroupIdBySurveyQuery(dsl, survey))});
    }

    protected static class JooqDSLContext
    extends SurveyObjectMappingDSLContext<Integer, DataReport> {
        private static final long serialVersionUID = 1L;

        public JooqDSLContext(Configuration config) {
            this(config, null);
        }

        public JooqDSLContext(Configuration config, CollectSurvey survey) {
            super(config, OfcDataReport.OFC_DATA_REPORT.ID, Sequences.OFC_DATA_REPORT_ID_SEQ, DataReport.class, survey);
        }

        protected DataReport newEntity() {
            return new DataReport(this.survey);
        }

        protected void fromRecord(Record r, DataReport o) {
            super.fromRecord(r, (PersistedSurveyObject)o);
            o.setCreationDate((Date)r.getValue((Field)OfcDataReport.OFC_DATA_REPORT.CREATION_DATE));
            o.setDatasetSize((Integer)r.getValue((Field)OfcDataReport.OFC_DATA_REPORT.DATASET_SIZE));
            o.setLastRecordModifiedDate((Date)r.getValue((Field)OfcDataReport.OFC_DATA_REPORT.LAST_RECORD_MODIFIED_DATE));
            o.setQueryGroupId((Integer)r.getValue((Field)OfcDataReport.OFC_DATA_REPORT.QUERY_GROUP_ID));
            o.setRecordStep(CollectRecord.Step.valueOf((int)((Integer)r.getValue((Field)OfcDataReport.OFC_DATA_REPORT.RECORD_STEP))));
            o.setUuid(UUID.fromString((String)r.getValue((Field)OfcDataReport.OFC_DATA_REPORT.UUID)));
        }

        protected void fromObject(DataReport o, StoreQuery<?> q) {
            super.fromObject((PersistedSurveyObject)o, q);
            q.addValue((Field)OfcDataReport.OFC_DATA_REPORT.CREATION_DATE, (Object)DataReportDao.toTimestamp((Date)o.getCreationDate()));
            q.addValue((Field)OfcDataReport.OFC_DATA_REPORT.DATASET_SIZE, (Object)o.getDatasetSize());
            q.addValue((Field)OfcDataReport.OFC_DATA_REPORT.LAST_RECORD_MODIFIED_DATE, (Object)DataReportDao.toTimestamp((Date)o.getLastRecordModifiedDate()));
            q.addValue((Field)OfcDataReport.OFC_DATA_REPORT.QUERY_GROUP_ID, (Object)o.getQueryGroupId());
            q.addValue((Field)OfcDataReport.OFC_DATA_REPORT.RECORD_STEP, (Object)o.getRecordStep().getStepNumber());
            q.addValue((Field)OfcDataReport.OFC_DATA_REPORT.UUID, (Object)o.getUuid().toString());
        }
    }
}

