/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.metamodel;

import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeDefinitionVisitor;
import org.openforis.idm.metamodel.NodeLabel;

public class SchemaUpdater {
    private CollectSurvey survey;

    public SchemaUpdater(CollectSurvey survey) {
        this.survey = survey;
    }

    public void addChildDefinition(EntityDefinition parentDef, NodeDefinition childDef) {
        parentDef.addChildDefinition(childDef);
    }

    public EntityDefinition generateAlias(EntityDefinition sourceDef, String sourceFilterAttributeName, EntityDefinition targetParentDef, String targetFilterAttributeName) {
        EntityDefinition aliasDef = (EntityDefinition)this.survey.getSchema().cloneDefinition((NodeDefinition)sourceDef, new String[]{targetFilterAttributeName});
        for (NodeLabel nodeLabel : aliasDef.getLabels()) {
            aliasDef.setLabel((NodeLabel.Type)nodeLabel.getType(), nodeLabel.getLanguage(), nodeLabel.getText() + " Alias");
        }
        aliasDef.traverse(new NodeDefinitionVisitor(){

            public void visit(NodeDefinition def) {
                if (def instanceof AttributeDefinition) {
                    AttributeDefinition attrDef = (AttributeDefinition)def;
                    attrDef.setCalculated(false);
                    attrDef.removeAllChecks();
                    attrDef.removeAllAttributeDefaults();
                }
                def.setRelevantExpression(null);
                def.setRequiredExpression(null);
            }
        });
        targetParentDef.addChildDefinition((NodeDefinition)aliasDef);
        aliasDef.setVirtual(true);
        aliasDef.setGeneratorExpression(this.generateAliasGeneratorExpression(sourceDef, sourceFilterAttributeName, targetParentDef, targetFilterAttributeName));
        UIOptions uiOptions = this.survey.getUIOptions();
        uiOptions.setLayout(aliasDef, UIOptions.Layout.FORM);
        uiOptions.setHidden((NodeDefinition)aliasDef, true);
        return aliasDef;
    }

    private String generateAliasGeneratorExpression(EntityDefinition sourceDef, String sourceFilterAttributeName, EntityDefinition targetParentDef, String targetFilterAttributeName) {
        return targetParentDef.getRelativePath((NodeDefinition)sourceDef) + String.format("[%s=$context/%s]", sourceFilterAttributeName, targetFilterAttributeName);
    }
}

