/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.openforis.collect.designer.form.CodeListItemFormObject;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.SurveyObjectPopUpVM;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.FileWrapper;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.PersistedCodeListItem;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public class CodeListItemVM
extends SurveyObjectPopUpVM<CodeListItem> {
    public static final String ITEM_ARG = "item";
    public static final String PARENT_ITEM_ARG = "parentItem";
    private static final int MAX_IMAGE_SIZE_KBYTES = 300;
    private static final int MAX_IMAGE_SIZE_BYTES = 307200;
    private static final String CANNOT_EDIT_CODE_MESSAGE_KEY = "survey.code_list.item.cannot_edit_code";
    @WireVariable
    private SurveyManager surveyManager;
    @WireVariable
    private CodeListManager codeListManager;
    private AImage image;
    private boolean imageModified;
    private FileWrapper newImageFileWrapper;

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="item") CodeListItem item) {
        super.init();
        this.setEditedItem(item);
        this.commitChangesOnApply = false;
        this.imageModified = false;
    }

    @Override
    protected void addNewItemToSurvey() {
    }

    @Override
    protected void deleteItemFromSurvey(CodeListItem item) {
    }

    @Override
    protected List<CodeListItem> getItemsInternal() {
        return null;
    }

    @Override
    protected void moveSelectedItemInSurvey(int indexTo) {
    }

    @Override
    protected CodeListItem createItemInstance() {
        return null;
    }

    @Override
    public void setEditedItem(CodeListItem editedItem) {
        FileWrapper fileWrapper;
        super.setEditedItem(editedItem);
        if (editedItem != null && editedItem instanceof PersistedCodeListItem && ((PersistedCodeListItem)editedItem).getSystemId() != null && (fileWrapper = this.codeListManager.loadImageContent((PersistedCodeListItem)editedItem)) != null) {
            try {
                this.image = new AImage(fileWrapper.getFileName(), fileWrapper.getContent());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected FormObject<CodeListItem> createFormObject() {
        return new CodeListItemFormObject();
    }

    @Override
    protected void dispatchChangesAppliedCommand(boolean ignoreUnsavedChanges) {
        if (ignoreUnsavedChanges) {
            this.postClosePopUpCommand(true);
        } else {
            this.postClosePopUpCommand(false, this.imageModified, this.newImageFileWrapper);
        }
    }

    @Override
    protected void dispatchChangesCancelledCommand() {
        this.postClosePopUpCommand(true);
    }

    @Command(value={"imageUpload"})
    public void onImageUpload(@ContextParam(value=ContextType.BIND_CONTEXT) BindContext ctx) {
        UploadEvent upEvent = null;
        Event objUploadEvent = ctx.getTriggerEvent();
        if (objUploadEvent != null && objUploadEvent instanceof UploadEvent) {
            upEvent = (UploadEvent)objUploadEvent;
        }
        if (this.checkValidImage(upEvent)) {
            Media media = upEvent.getMedia();
            this.image = (AImage)media;
            this.newImageFileWrapper = new FileWrapper(media.getByteData(), media.getName());
            this.imageModified = true;
            this.notifyChange("image", "imageModified");
        }
    }

    private boolean checkValidImage(UploadEvent upEvent) {
        if (upEvent != null) {
            Media media = upEvent.getMedia();
            if (media instanceof Image) {
                int lengthofImage = media.getByteData().length;
                if (lengthofImage > 307200) {
                    MessageUtil.showInfo("survey.code_list.image.error.max_size_exceeded", 300);
                    return false;
                }
                return true;
            }
            MessageUtil.showInfo("survey.code_list.image.error.not_an_image", new Object[0]);
            return false;
        }
        return false;
    }

    @Command(value={"removeImage"})
    public void removeImage() {
        this.imageModified = true;
        this.image = null;
        this.newImageFileWrapper = null;
        this.notifyChange("image", "imageModified");
    }

    private void postClosePopUpCommand(boolean undoChanges) {
        this.postClosePopUpCommand(undoChanges, false, null);
    }

    private void postClosePopUpCommand(boolean undoChanges, boolean imageModified, FileWrapper imageFileWrapper) {
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("undoChanges", undoChanges);
        args.put("imageModified", imageModified);
        args.put("imageFileWrapper", (Boolean)imageFileWrapper);
        BindUtils.postGlobalCommand(null, null, (String)"closeCodeListItemPopUp", args);
    }

    public AImage getImage() {
        return this.image;
    }

    public boolean isImageModified() {
        return this.imageModified;
    }

    public CodeListManager getCodeListManager() {
        return this.codeListManager;
    }

    public boolean isCodeReadOnly() {
        if (((CodeListItem)this.editedItem).getCodeList().isEnumeratingList() && this.survey.isPublished() && this.survey.getPublishedId() != null) {
            CollectSurvey publishedSurvey = this.surveyManager.getById(this.survey.getPublishedId().intValue());
            CodeList publishedCodeList = publishedSurvey.getCodeListById(((CodeListItem)this.editedItem).getCodeList().getId());
            CodeListItem publishedItem = this.codeListManager.loadItem(publishedCodeList, ((CodeListItem)this.editedItem).getId());
            return publishedItem != null;
        }
        return false;
    }

    public String getCodeTooltipText() {
        return this.isCodeReadOnly() ? Labels.getLabel((String)CANNOT_EDIT_CODE_MESSAGE_KEY) : null;
    }
}

