/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.collectearth.balloon;

import com.jamesmurty.utils.XMLBuilder;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.io.metadata.collectearth.CollectEarthProjectFileCreatorImpl;
import org.openforis.collect.io.metadata.collectearth.balloon.CEAncillaryFields;
import org.openforis.collect.io.metadata.collectearth.balloon.CECodeField;
import org.openforis.collect.io.metadata.collectearth.balloon.CEComponent;
import org.openforis.collect.io.metadata.collectearth.balloon.CEEnumeratedEntityTable;
import org.openforis.collect.io.metadata.collectearth.balloon.CEEnumeratingCodeField;
import org.openforis.collect.io.metadata.collectearth.balloon.CEField;
import org.openforis.collect.io.metadata.collectearth.balloon.CEFieldSet;
import org.openforis.collect.io.metadata.collectearth.balloon.CERangeField;
import org.openforis.collect.io.metadata.collectearth.balloon.CETab;
import org.openforis.collect.io.metadata.collectearth.balloon.CETabSet;
import org.openforis.collect.io.metadata.collectearth.balloon.CETableRow;
import org.openforis.collect.io.metadata.collectearth.balloon.HtmlUnicodeEscaperUtil;
import org.openforis.collect.io.metadata.collectearth.balloon.Messages;
import org.openforis.idm.metamodel.CodeListItem;

public class CEComponentHTMLFormatter {
    private static final String EXTRA_VALUE_FORMAT = "$[EXTRA_%s]";
    private String language;

    public CEComponentHTMLFormatter(String language) {
        this.language = language;
    }

    public String format(CETabSet tabSet) {
        try {
            XMLBuilder builder = this.createBuilder(tabSet, null);
            return this.writeToString(builder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XMLBuilder createBuilder(CETabSet tabSet, XMLBuilder parentBuilder) throws Exception {
        XMLBuilder tabSetBuilder = parentBuilder == null ? XMLBuilder.create((String)"div") : parentBuilder.e("div");
        tabSetBuilder.a("class", "steps");
        for (CETab tab : tabSet.getTabs()) {
            this.createBuilder(tab, tabSetBuilder);
        }
        return tabSetBuilder;
    }

    private XMLBuilder createBuilder(CETab tab, XMLBuilder parentBuilder) throws Exception {
        parentBuilder.e("h3").t(HtmlUnicodeEscaperUtil.escapeHtmlUnicode(tab.getLabel()));
        XMLBuilder bodyContentBuilder = parentBuilder.e("section");
        bodyContentBuilder.a("class", "step");
        if (tab.getAncillaryDataHeader() != null) {
            this.createBuilder(tab.getAncillaryDataHeader(), bodyContentBuilder);
        }
        for (CEComponent component : tab.getChildren()) {
            if (component instanceof CEField) {
                this.createBuilder((CEField)component, true, bodyContentBuilder);
                continue;
            }
            if (component instanceof CEEnumeratedEntityTable) {
                this.createBuilder((CEEnumeratedEntityTable)component, bodyContentBuilder);
                continue;
            }
            if (!(component instanceof CEFieldSet)) continue;
            this.createBuilder((CEFieldSet)component, bodyContentBuilder);
        }
        return bodyContentBuilder;
    }

    private XMLBuilder createBuilder(CEEnumeratedEntityTable comp, XMLBuilder parentBuilder) throws Exception {
        XMLBuilder builder = parentBuilder.e("fieldset").attr("class", "entity-group");
        String legend = comp.getLabelOrName();
        XMLBuilder legendBuilder = builder.e("legend");
        legendBuilder.e("span").text(legend);
        this.addTooltip(legendBuilder, comp.getTooltip());
        XMLBuilder tableBuilder = builder.e("table").a("class", "table");
        XMLBuilder headerBuilder = tableBuilder.e("thead").e("tr");
        for (String heading : comp.getHeadings()) {
            headerBuilder.e("th").t(HtmlUnicodeEscaperUtil.escapeHtmlUnicode(heading));
        }
        XMLBuilder bodyBuilder = tableBuilder.e("tbody");
        List<CETableRow> rows = comp.getRows();
        for (CETableRow row : rows) {
            XMLBuilder rowBuilder = bodyBuilder.e("tr");
            for (CEComponent child : row.getChildren()) {
                XMLBuilder cellBuilder = rowBuilder.e("td");
                if (child instanceof CEEnumeratingCodeField) {
                    cellBuilder.e("label").a("class", "control-label col-sm-4").t(row.getLabelOrName());
                    String tooltip = row.getTooltip();
                    this.addTooltip(cellBuilder, tooltip);
                    continue;
                }
                if (!(child instanceof CEField)) continue;
                this.createBuilder((CEField)child, false, cellBuilder);
            }
        }
        return builder;
    }

    private XMLBuilder createBuilder(CEFieldSet comp, XMLBuilder parentBuilder) throws Exception {
        XMLBuilder fieldSetBuilder = parentBuilder.e("fieldset").attr("class", "entity-group");
        fieldSetBuilder.e("legend").t(comp.getLabelOrName());
        for (CEComponent child : comp.getChildren()) {
            if (child instanceof CEField) {
                this.createBuilder((CEField)child, true, fieldSetBuilder);
                continue;
            }
            throw new IllegalArgumentException("Only attribute fields supported inside single entity");
        }
        return fieldSetBuilder;
    }

    private XMLBuilder createBuilder(CEAncillaryFields comp, XMLBuilder parentBuilder) throws Exception {
        XMLBuilder informationFieldsBuilder = parentBuilder.e("div").attr("class", "ancillary-data");
        boolean firstChild = true;
        for (CEComponent child : comp.getChildren()) {
            if (child instanceof CEField) {
                informationFieldsBuilder.e("span").t((firstChild ? " " : ", ") + child.getLabelOrName() + ": $[" + "EXTRA_" + child.getName() + "]");
                firstChild = false;
                continue;
            }
            throw new IllegalArgumentException("Only attribute fields supported inside single entity");
        }
        return informationFieldsBuilder;
    }

    private XMLBuilder createBuilder(CEField comp, boolean includeLabel, XMLBuilder parentBuilder) throws Exception {
        String componentAdditionalClass;
        String elId = comp.getHtmlParameterName();
        XMLBuilder formGroupBuilder = parentBuilder == null ? XMLBuilder.create((String)"div") : parentBuilder.e("div");
        formGroupBuilder.a("class", "form-group");
        if (includeLabel) {
            formGroupBuilder.e("label").a("for", elId).a("class", "control-label col-sm-4").t(comp.getLabelOrName());
            String tooltip = comp.getTooltip();
            this.addTooltip(formGroupBuilder, tooltip);
        }
        XMLBuilder formControlContainer = formGroupBuilder.e("div").a("class", "col-sm-8");
        String string = componentAdditionalClass = comp.isExtra() ? " extra" : "";
        if (comp instanceof CECodeField) {
            if (comp.isReadOnly()) {
                XMLBuilder inputBuilder = formControlContainer.e("input").a("id", elId).a("name", elId).a("type", "text").a("class", "form-control" + componentAdditionalClass).a("disabled", "disabled");
                if (comp.isExtra()) {
                    inputBuilder.a("value", String.format(EXTRA_VALUE_FORMAT, comp.getName()));
                }
            } else {
                switch (comp.getType()) {
                    case CODE_BUTTON_GROUP: {
                        this.buildCodeButtonGroup(formControlContainer, (CECodeField)comp);
                        break;
                    }
                    case CODE_SELECT: {
                        this.buildCodeSelect(formControlContainer, (CECodeField)comp);
                        break;
                    }
                    case CODE_RANGE: {
                        this.buildCodeRange(formControlContainer, (CERangeField)comp);
                        break;
                    }
                }
            }
        } else if (!(comp instanceof CEEnumeratingCodeField) && comp instanceof CEField) {
            switch (comp.getType()) {
                case SHORT_TEXT: {
                    XMLBuilder fieldBuilder = formControlContainer.e("input").a("id", elId).a("name", elId).a("type", "text").a("class", "form-control" + componentAdditionalClass);
                    if (!comp.isReadOnly()) break;
                    fieldBuilder.a("disabled", "disabled");
                    if (!comp.isExtra()) break;
                    fieldBuilder.a("value", String.format(EXTRA_VALUE_FORMAT, comp.getName()));
                    break;
                }
                case LONG_TEXT: {
                    XMLBuilder fieldBuilder = formControlContainer.e("textarea").a("id", elId).a("rows", "3").a("name", elId).a("class", "form-control" + componentAdditionalClass).t(" ");
                    if (!comp.isReadOnly()) break;
                    fieldBuilder.a("disabled", "disabled");
                    if (!comp.isExtra()) break;
                    fieldBuilder.a("value", String.format(EXTRA_VALUE_FORMAT, comp.getName()));
                    break;
                }
                case INTEGER: 
                case REAL: {
                    XMLBuilder fieldBuilder = formControlContainer.e("input").a("id", elId).a("name", elId).a("type", "text").a("class", "form-control numeric" + componentAdditionalClass);
                    String value = "0";
                    if (comp.isReadOnly()) {
                        fieldBuilder.a("disabled", "disabled");
                        if (comp.isExtra()) {
                            value = String.format(EXTRA_VALUE_FORMAT, comp.getName());
                        }
                    }
                    fieldBuilder.a("value", value);
                    break;
                }
                case BOOLEAN: {
                    if (comp.isReadOnly()) {
                        XMLBuilder fieldBuilder = formControlContainer.e("input").a("id", elId).a("name", elId).a("type", "text").a("class", "form-control" + componentAdditionalClass).a("data-field-type", comp.getType().name()).a("disabled", "disabled");
                        if (!comp.isExtra()) break;
                        fieldBuilder.a("value", String.format(EXTRA_VALUE_FORMAT, comp.getName()));
                        break;
                    }
                    XMLBuilder containerBuilder = formControlContainer.e("div").a("class", "boolean-group").a("data-toggle", "buttons-radio");
                    containerBuilder.e("input").a("id", elId).a("name", elId).a("type", "hidden").a("class", "form-control").a("data-field-type", comp.getType().name());
                    containerBuilder.e("button").a("type", "button").a("class", "btn btn-info").a("value", "true").t(HtmlUnicodeEscaperUtil.escapeHtmlUnicode(Messages.getString("CEComponentHTMLFormatter.0", this.language)));
                    containerBuilder.e("button").a("type", "button").a("class", "btn btn-info").a("value", "false").t(HtmlUnicodeEscaperUtil.escapeHtmlUnicode(Messages.getString("CEComponentHTMLFormatter.88", this.language)));
                    break;
                }
                case COORDINATE: {
                    break;
                }
                case DATE: 
                case TIME: {
                    XMLBuilder groupContainerBuilder = formControlContainer.e("div").a("class", "input-group date " + (comp.getType() == CEField.CEFieldType.DATE ? "datepicker" : "timepicker"));
                    XMLBuilder inputFieldBuilder = groupContainerBuilder.e("input").a("id", elId).a("name", elId).a("class", "form-control");
                    groupContainerBuilder.e("span").a("class", "input-group-addon").e("span").a("class", "glyphicon glyphicon-time");
                    if (!comp.isReadOnly()) break;
                    inputFieldBuilder.a("disabled", "disabled");
                    if (!comp.isExtra()) break;
                    inputFieldBuilder.a("value", String.format(EXTRA_VALUE_FORMAT, comp.getName()));
                    break;
                }
            }
        }
        return formGroupBuilder;
    }

    public void addTooltip(XMLBuilder formGroupBuilder, String tooltip) {
        if (!StringUtils.isBlank((CharSequence)tooltip)) {
            formGroupBuilder.e("span").a("class", "ui-icon  ui-icon-info").a("style", "display:inline-block").a("title", tooltip);
        }
    }

    private void buildCodeSelect(XMLBuilder builder, CECodeField comp) {
        Map<Integer, List<CodeListItem>> itemsByParentCode;
        List<CodeListItem> rootItems;
        String elId = comp.getHtmlParameterName();
        XMLBuilder selectBuilder = builder.e("select").a("id", elId).a("name", elId).a("data-field-type", comp.getType().name()).a("class", "form-control selectboxit show-menu-arrow show-tick").a("data-width", "75px");
        if (comp.getParentName() != null) {
            selectBuilder.a("data-parent-id-field-id", comp.getParentName());
        }
        if ((rootItems = (itemsByParentCode = comp.getCodeItemsByParentId()).get(0)) != null) {
            boolean hasNAoption = false;
            for (CodeListItem item : rootItems) {
                if (!item.getCode().equalsIgnoreCase("na") && !item.getCode().equalsIgnoreCase("n/a")) continue;
                hasNAoption = true;
            }
            if (!hasNAoption) {
                selectBuilder.e("option").a("selected", "true").a("value", "").t(Messages.getString("CEComponentHTMLFormatter.119", this.language));
            }
            for (CodeListItem item : rootItems) {
                String itemLabel = this.getItemLabel(item);
                selectBuilder.e("option").a("value", item.getCode()).t(itemLabel);
            }
        }
    }

    private void buildCodeRange(XMLBuilder builder, CERangeField comp) {
        String elId = comp.getHtmlParameterName();
        XMLBuilder selectBuilder = builder.e("select").a("id", elId).a("name", elId).a("data-field-type", comp.getType().name()).a("class", "form-control selectboxit show-menu-arrow show-tick").a("data-width", "75px");
        for (int i = comp.getFrom().intValue(); i < comp.getTo(); ++i) {
            String item = i + "";
            selectBuilder.e("option").a("value", item).t(item);
        }
    }

    private void buildCodeButtonGroup(XMLBuilder formControlContainer, CECodeField comp) {
        String elId = comp.getHtmlParameterName();
        String groupId = elId + "_group";
        XMLBuilder itemsGroupExternalContainer = formControlContainer.e("div").a("id", groupId).a("class", "code-items-group");
        XMLBuilder hiddenInputField = itemsGroupExternalContainer.e("input").a("id", elId).a("name", elId).a("type", "hidden").a("class", "form-control").a("data-field-type", comp.getType().name());
        if (comp.getParentName() != null) {
            hiddenInputField.a("data-parent-id-field-id", comp.getParentName());
        }
        Map<Integer, List<CodeListItem>> itemsByParentCode = comp.getCodeItemsByParentId();
        for (Map.Entry<Integer, List<CodeListItem>> entry : itemsByParentCode.entrySet()) {
            List<CodeListItem> items;
            Integer parentId = entry.getKey();
            String itemsGroupId = groupId + "_" + parentId;
            XMLBuilder buttonsGroup = itemsGroupExternalContainer.e("div").a("id", itemsGroupId).a("class", "code-items").a("data-toggle", comp.isMultiple() ? "buttons" : "buttons-radio");
            if (parentId != 0) {
                buttonsGroup.a("data-parent-id", parentId.toString()).a("style", "display: none;");
            }
            if ((items = entry.getValue()) == null || items.isEmpty()) {
                buttonsGroup.t(" ");
                continue;
            }
            for (CodeListItem item : items) {
                String itemLabel = this.getItemLabel(item);
                XMLBuilder itemBuilder = buttonsGroup.e("button").a("type", "button").a("class", "btn btn-info code-item").a("data-code-item-id", String.valueOf(item.getId())).a("value", item.getCode()).t(itemLabel);
                String description = this.getDescription(item);
                if (item.hasUploadedImage()) {
                    String imgFilePath = CollectEarthProjectFileCreatorImpl.getCodeListImageFilePath(item);
                    String titleText = StringUtils.isBlank((CharSequence)description) ? "" : description;
                    String htmlTitle = "<span><img src=\"" + imgFilePath + "\" width=\"250\"><br/>" + titleText + "</span>";
                    itemBuilder.a("title", htmlTitle).a("data-html", "true").a("data-placement", "auto bottom");
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)description)) continue;
                itemBuilder.a("title", description);
            }
        }
    }

    private String writeToString(XMLBuilder builder) {
        try {
            StringWriter writer = new StringWriter();
            Properties outputProperties = new Properties(){
                {
                    this.put("indent", "yes");
                    this.put("omit-xml-declaration", "yes");
                    this.put("standalone", "yes");
                    this.put("method", "html");
                }
            };
            builder.toWriter((Writer)writer, outputProperties);
            String result = writer.toString();
            return result.replaceAll("&amp;#", "&#");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getItemLabel(CodeListItem item) {
        return CEComponentHTMLFormatter.getItemLabel(item, this.language);
    }

    private String getDescription(CodeListItem item) {
        return CEComponentHTMLFormatter.getDescription(item, this.language);
    }

    public static String getItemLabel(CodeListItem item, String lang) {
        String itemLabel = item.getLabel(lang, true);
        if (StringUtils.isBlank((CharSequence)itemLabel)) {
            itemLabel = item.getCode();
        }
        return HtmlUnicodeEscaperUtil.escapeHtmlUnicode(itemLabel);
    }

    public static String getDescription(CodeListItem item, String lang) {
        String description = item.getDescription(lang, true);
        return HtmlUnicodeEscaperUtil.escapeHtmlUnicode(description);
    }
}

