/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.collectearth.balloon;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.CodePointTranslator;
import org.apache.commons.lang3.text.translate.LookupTranslator;

public class HtmlUnicodeEscaperUtil
extends CodePointTranslator {
    public static final String MONDRIAN_START_UNICODE = "REPLACE_START_UNICODE";
    private final int below;
    private final int above;
    private final boolean between;
    private final String endWith;
    private final String startWith;
    private static final CharSequenceTranslator ESCAPE_UNICODE_BALLOON = new LookupTranslator((CharSequence[][])new CharSequence[0][]).with(new CharSequenceTranslator[]{HtmlUnicodeEscaperUtil.outsideOf(32, 127, "&", ";")});
    private static final CharSequenceTranslator ESCAPE_UNICODE_MONDRIAN = new LookupTranslator((CharSequence[][])new CharSequence[0][]).with(new CharSequenceTranslator[]{HtmlUnicodeEscaperUtil.outsideOf(32, 127, "REPLACE_START_UNICODE", ";")});

    public static String escapeForBalloon(String stringToEscape) {
        stringToEscape = StringEscapeUtils.escapeHtml4((String)stringToEscape);
        return HtmlUnicodeEscaperUtil.escapeHtmlUnicode(stringToEscape);
    }

    private HtmlUnicodeEscaperUtil() {
        this(0, Integer.MAX_VALUE, true, "&", "");
    }

    public static final String escapeHtmlUnicode(String input) {
        return ESCAPE_UNICODE_BALLOON.translate((CharSequence)input);
    }

    public static final String escapeMondrianUnicode(String input) {
        return ESCAPE_UNICODE_MONDRIAN.translate((CharSequence)input);
    }

    private HtmlUnicodeEscaperUtil(int below, int above, boolean between, String startWith, String endWith) {
        this.below = below;
        this.above = above;
        this.between = between;
        this.startWith = startWith;
        this.endWith = endWith;
    }

    private static HtmlUnicodeEscaperUtil outsideOf(int codepointLow, int codepointHigh, String startWith, String endWith) {
        return new HtmlUnicodeEscaperUtil(codepointLow, codepointHigh, false, startWith, endWith);
    }

    public boolean translate(int codepoint, Writer out) throws IOException {
        if (this.between ? codepoint < this.below || codepoint > this.above : codepoint >= this.below && codepoint <= this.above) {
            return false;
        }
        if (codepoint > 65535) {
            out.write(this.startWith + "#x" + HtmlUnicodeEscaperUtil.hex((int)codepoint) + this.endWith);
        } else if (codepoint > 4095) {
            out.write(this.startWith + "#x" + HtmlUnicodeEscaperUtil.hex((int)codepoint) + this.endWith);
        } else if (codepoint > 255) {
            out.write(this.startWith + "#x0" + HtmlUnicodeEscaperUtil.hex((int)codepoint) + this.endWith);
        } else if (codepoint > 15) {
            out.write(this.startWith + "#x00" + HtmlUnicodeEscaperUtil.hex((int)codepoint) + this.endWith);
        } else {
            out.write(this.startWith + "#x000" + HtmlUnicodeEscaperUtil.hex((int)codepoint) + this.endWith);
        }
        return true;
    }
}

