/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.species;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.io.exception.ParsingException;
import org.openforis.collect.io.metadata.ReferenceDataImportTask;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.openforis.collect.io.metadata.species.SpeciesFileColumn;
import org.openforis.collect.io.parsing.CSVFileOptions;
import org.openforis.collect.manager.SpeciesManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.speciesimport.SpeciesCSVReader;
import org.openforis.collect.manager.speciesimport.SpeciesLine;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.CollectTaxonomy;
import org.openforis.collect.model.TaxonTree;
import org.openforis.collect.persistence.SurveyStoreException;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.ReferenceDataSchema;
import org.openforis.idm.model.species.Taxon;
import org.openforis.idm.model.species.TaxonVernacularName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SpeciesImportTask
extends ReferenceDataImportTask<ParsingError> {
    private static final Logger LOG = LogManager.getLogger(SpeciesImportTask.class);
    private static final String RAW_SCIENTIFIC_NAME_TREE_NODE_METADATA = "rawScientificName";
    private static final String LINE_NUMBER_TREE_NODE_METADATA = "lineNumber";
    private static final String TAXONOMY_NOT_FOUND_ERROR_MESSAGE_KEY = "survey.taxonomy.import_data.error.taxonomyNotFound";
    private static final String INVALID_FAMILY_NAME_ERROR_MESSAGE_KEY = "survey.taxonomy.import_data.error.invalidFamilyName";
    private static final String INVALID_GENUS_NAME_ERROR_MESSAGE_KEY = "survey.taxonomy.import_data.error.invalidGenusName";
    private static final String INVALID_SPECIES_NAME_ERROR_MESSAGE_KEY = "survey.taxonomy.import_data.error.invalidSpeciesName";
    private static final String INVALID_SCIENTIFIC_NAME_ERROR_MESSAGE_KEY = "survey.taxonomy.import_data.error.invalidScientificName";
    private static final String IMPORTING_FILE_ERROR_MESSAGE_KEY = "survey.taxonomy.import_data.error.internalErrorImportingFile";
    private static final Taxon.TaxonRank[] TAXON_RANKS = new Taxon.TaxonRank[]{Taxon.TaxonRank.FAMILY, Taxon.TaxonRank.GENUS, Taxon.TaxonRank.SPECIES, Taxon.TaxonRank.SUBSPECIES, Taxon.TaxonRank.VARIETY, Taxon.TaxonRank.CULTIVAR, Taxon.TaxonRank.FORM};
    @Autowired
    private SpeciesManager speciesManager;
    @Autowired
    private SurveyManager surveyManager;
    private CollectSurvey survey;
    private int taxonomyId;
    private File file;
    private CSVFileOptions csvFileOptions;
    private boolean overwriteAll = true;
    private String taxonomyName;
    private TaxonTree taxonTree;
    private SpeciesCSVReader reader;
    private List<SpeciesLine> lines;

    protected void initializeInternalVariables() throws Throwable {
        super.initializeInternalVariables();
        CollectTaxonomy taxonomy = this.speciesManager.loadTaxonomyById(this.survey, this.taxonomyId);
        this.taxonomyName = taxonomy.getName();
        this.lines = new ArrayList<SpeciesLine>();
    }

    protected void validateInput() throws Throwable {
        super.validateInput();
        if (!this.file.exists() && !this.file.canRead()) {
            this.setErrorMessage(IMPORTING_FILE_ERROR_MESSAGE_KEY);
            this.changeStatus(Worker.Status.FAILED);
        } else if (this.taxonomyId <= 0) {
            this.setErrorMessage(TAXONOMY_NOT_FOUND_ERROR_MESSAGE_KEY);
            this.changeStatus(Worker.Status.FAILED);
        }
    }

    protected void execute() throws Throwable {
        this.parseTaxonCSVLines(this.file);
        if (this.isRunning()) {
            this.processLines();
        }
        if (this.isRunning() && !this.hasErrors()) {
            this.persistTaxa();
        } else {
            this.changeStatus(Worker.Status.FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseTaxonCSVLines(File file) {
        long currentRowNumber = 0L;
        try {
            this.reader = new SpeciesCSVReader(file, this.csvFileOptions);
            this.reader.init();
            ReferenceDataSchema.TaxonomyDefinition taxonomyDefinition = this.initializeTaxonomyDefinition();
            this.taxonTree = new TaxonTree(taxonomyDefinition);
            this.addProcessedRow(1L);
            currentRowNumber = 2L;
            while (this.isRunning()) {
                try {
                    SpeciesLine line = (SpeciesLine)this.reader.readNextLine();
                    if (line != null) {
                        this.lines.add(line);
                    }
                    if (this.reader.isReady()) continue;
                    break;
                }
                catch (ParsingException e) {
                    this.addParsingError(currentRowNumber, e.getError());
                }
                finally {
                    ++currentRowNumber;
                }
            }
            this.setTotalItems(this.reader.getLinesRead() + 1L);
        }
        catch (ParsingException e) {
            this.addParsingError(1L, e.getError());
            this.changeStatus(Worker.Status.FAILED);
        }
        catch (Exception e) {
            this.addParsingError(currentRowNumber, new ParsingError(ParsingError.ErrorType.IOERROR, e.getMessage()));
            this.changeStatus(Worker.Status.FAILED);
            LOG.error("Error importing species CSV file", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Object)this.reader));
        }
    }

    private ReferenceDataSchema.TaxonomyDefinition initializeTaxonomyDefinition() {
        List infoColumnNames = this.reader.getInfoColumnNames();
        ReferenceDataSchema.TaxonomyDefinition taxonomyDefinition = new ReferenceDataSchema.TaxonomyDefinition(this.taxonomyName);
        taxonomyDefinition.setAttributes(ReferenceDataSchema.ReferenceDataDefinition.Attribute.fromNames((List)infoColumnNames));
        ReferenceDataSchema referenceDataSchema = this.survey.getReferenceDataSchema();
        referenceDataSchema.addTaxonomyDefinition(taxonomyDefinition);
        return taxonomyDefinition;
    }

    protected void processLines() {
        for (Taxon.TaxonRank rank : TAXON_RANKS) {
            for (SpeciesLine line : this.lines) {
                long lineNumber = line.getLineNumber();
                if (this.isRowProcessed(lineNumber) || this.isRowInError(lineNumber)) continue;
                try {
                    boolean processed = this.processLine(line, rank);
                    if (!processed) continue;
                    this.addProcessedRow(lineNumber);
                }
                catch (ParsingException e) {
                    this.addParsingError(lineNumber, e.getError());
                }
            }
        }
    }

    protected boolean processLine(SpeciesLine line, Taxon.TaxonRank rank) throws ParsingException {
        boolean mostSpecificRank = line.getRank() == rank;
        switch (rank) {
            case FAMILY: {
                this.createTaxonFamily(line);
                return mostSpecificRank;
            }
            case GENUS: {
                this.createTaxonGenus(line);
                return mostSpecificRank;
            }
            case SPECIES: {
                this.createTaxonSpecies(line);
                return mostSpecificRank;
            }
            case SUBSPECIES: 
            case VARIETY: 
            case CULTIVAR: 
            case FORM: {
                Taxon parent = this.findParentTaxon(line);
                if (!mostSpecificRank || parent == null) {
                    return false;
                }
                this.createTaxon(line, rank, parent);
                return true;
            }
        }
        return false;
    }

    protected void processVernacularNames(SpeciesLine line, Taxon taxon) {
        Map<String, List<String>> langToVernacularName = line.getLanguageToVernacularNames();
        Set<String> vernacularLangCodes = langToVernacularName.keySet();
        for (String langCode : vernacularLangCodes) {
            List<String> vernacularNames = langToVernacularName.get(langCode);
            for (String vernacularName : vernacularNames) {
                TaxonVernacularName taxonVN = new TaxonVernacularName();
                taxonVN.setLanguageCode(langCode);
                taxonVN.setVernacularName(vernacularName);
                this.taxonTree.addVernacularName(taxon, taxonVN);
            }
        }
    }

    protected void persistTaxa() throws SurveyStoreException {
        this.saveSurvey();
        CollectTaxonomy taxonomy = this.speciesManager.loadTaxonomyById(this.survey, this.taxonomyId);
        this.speciesManager.insertTaxons(taxonomy, this.taxonTree, this.overwriteAll);
    }

    private void saveSurvey() throws SurveyStoreException {
        if (this.survey.isTemporary()) {
            this.surveyManager.save(this.survey);
        } else {
            this.surveyManager.updateModel(this.survey);
        }
    }

    private Taxon findParentTaxon(SpeciesLine line) throws ParsingException {
        String scientificName;
        Taxon.TaxonRank rank = line.getRank();
        Taxon.TaxonRank parentRank = rank.getParent();
        switch (parentRank) {
            case FAMILY: {
                scientificName = line.getFamilyName();
                break;
            }
            case GENUS: {
                scientificName = line.getGenus();
                break;
            }
            case SPECIES: {
                scientificName = line.getSpeciesName();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported rank");
            }
        }
        Taxon result = this.taxonTree.findTaxonByScientificName(scientificName);
        return result;
    }

    protected Taxon createTaxonFamily(SpeciesLine line) throws ParsingException {
        String familyName = line.getFamilyName();
        if (familyName == null) {
            ParsingError error = new ParsingError(ParsingError.ErrorType.INVALID_VALUE, line.getLineNumber(), SpeciesFileColumn.SCIENTIFIC_NAME.getColumnName(), INVALID_FAMILY_NAME_ERROR_MESSAGE_KEY);
            throw new ParsingException(error);
        }
        return this.createTaxon(line, Taxon.TaxonRank.FAMILY, null, familyName);
    }

    protected Taxon createTaxonGenus(SpeciesLine line) throws ParsingException {
        String genus = line.getGenus();
        if (genus == null) {
            ParsingError error = new ParsingError(ParsingError.ErrorType.INVALID_VALUE, line.getLineNumber(), SpeciesFileColumn.SCIENTIFIC_NAME.getColumnName(), INVALID_GENUS_NAME_ERROR_MESSAGE_KEY);
            throw new ParsingException(error);
        }
        Taxon taxonFamily = this.createTaxonFamily(line);
        String normalizedScientificName = StringUtils.join((Object[])new String[]{genus, " ", "sp."});
        return this.createTaxon(line, Taxon.TaxonRank.GENUS, taxonFamily, normalizedScientificName);
    }

    protected Taxon createTaxonSpecies(SpeciesLine line) throws ParsingException {
        String speciesName = line.getRank() == Taxon.TaxonRank.SPECIES ? line.getCanonicalScientificName() : line.getSpeciesName();
        if (speciesName == null) {
            ParsingError error = new ParsingError(ParsingError.ErrorType.INVALID_VALUE, line.getLineNumber(), SpeciesFileColumn.SCIENTIFIC_NAME.getColumnName(), INVALID_SPECIES_NAME_ERROR_MESSAGE_KEY);
            throw new ParsingException(error);
        }
        Taxon taxonGenus = this.createTaxonGenus(line);
        return this.createTaxon(line, Taxon.TaxonRank.SPECIES, taxonGenus, speciesName);
    }

    protected Taxon createTaxon(SpeciesLine line, Taxon.TaxonRank rank, Taxon parent) throws ParsingException {
        String normalizedScientificName = line.getCanonicalScientificName();
        if (normalizedScientificName == null) {
            ParsingError error = new ParsingError(ParsingError.ErrorType.INVALID_VALUE, line.getLineNumber(), SpeciesFileColumn.SCIENTIFIC_NAME.getColumnName(), INVALID_SCIENTIFIC_NAME_ERROR_MESSAGE_KEY);
            throw new ParsingException(error);
        }
        return this.createTaxon(line, rank, parent, normalizedScientificName);
    }

    protected Taxon createTaxon(SpeciesLine line, Taxon.TaxonRank rank, Taxon parent, String normalizedScientificName) throws ParsingException {
        boolean newTaxon;
        boolean mostSpecificRank = line.getRank() == rank;
        Taxon taxon = this.taxonTree.findTaxonByScientificName(normalizedScientificName);
        boolean bl = newTaxon = taxon == null;
        if (newTaxon) {
            taxon = new Taxon();
            taxon.setTaxonRank(rank);
            taxon.setScientificName(normalizedScientificName);
            TaxonTree.Node node = this.taxonTree.addNode(parent, taxon);
            node.addMetadata(LINE_NUMBER_TREE_NODE_METADATA, (Object)line.getLineNumber());
            node.addMetadata(RAW_SCIENTIFIC_NAME_TREE_NODE_METADATA, (Object)line.getRawScientificName());
        } else if (mostSpecificRank) {
            this.checkDuplicateScientificName(line, parent, normalizedScientificName);
        }
        if (mostSpecificRank) {
            String code = line.getCode();
            Integer taxonId = line.getTaxonId();
            this.checkDuplicates(line, code, taxonId);
            taxon.setCode(code);
            taxon.setTaxonId(taxonId);
            ReferenceDataSchema.TaxonomyDefinition taxonDefinition = this.survey.getReferenceDataSchema().getTaxonomyDefinition(this.taxonomyName);
            List taxonAttributes = taxonDefinition.getAttributes();
            for (ReferenceDataSchema.ReferenceDataDefinition.Attribute attribute : taxonAttributes) {
                String value = line.getInfoAttribute(attribute.getName());
                taxon.addInfoAttribute(value);
            }
            this.taxonTree.updateNodeInfo(taxon);
            this.processVernacularNames(line, taxon);
        }
        return taxon;
    }

    protected void checkDuplicates(SpeciesLine line, String code, Integer taxonId) throws ParsingException {
        TaxonTree.Node foundNode = null;
        foundNode = this.taxonTree.getNodeByTaxonId(taxonId);
        if (foundNode != null) {
            this.throwDuplicateRowParsingException(line, SpeciesFileColumn.NO, foundNode);
        }
        if ((foundNode = this.taxonTree.getNodeByCode(code)) != null) {
            this.throwDuplicateRowParsingException(line, SpeciesFileColumn.CODE, foundNode);
        }
    }

    protected void checkDuplicateScientificName(SpeciesLine line, Taxon parent, String normalizedScientificName) throws ParsingException {
        TaxonTree.Node duplicateNode = this.taxonTree.getDuplicateScienfificNameNode(parent, normalizedScientificName);
        if (duplicateNode != null) {
            this.throwDuplicateRowParsingException(line, SpeciesFileColumn.SCIENTIFIC_NAME, duplicateNode);
        }
    }

    protected void throwDuplicateRowParsingException(SpeciesLine line, SpeciesFileColumn column, TaxonTree.Node foundNode) throws ParsingException {
        ParsingError error = new ParsingError(ParsingError.ErrorType.DUPLICATE_VALUE, line.getLineNumber(), column.getColumnName());
        error.setMessageArgs(new String[]{foundNode.getMetadata(LINE_NUMBER_TREE_NODE_METADATA).toString()});
        throw new ParsingException(error);
    }

    public void setSpeciesManager(SpeciesManager speciesManager) {
        this.speciesManager = speciesManager;
    }

    public void setSurveyManager(SurveyManager surveyManager) {
        this.surveyManager = surveyManager;
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public void setTaxonomyId(int taxonomyId) {
        this.taxonomyId = taxonomyId;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setCsvFileOptions(CSVFileOptions csvFileOptions) {
        this.csvFileOptions = csvFileOptions;
    }

    public void setOverwriteAll(boolean overwriteAll) {
        this.overwriteAll = overwriteAll;
    }
}

