/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel;

import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ObjectUtils;
import org.openforis.collect.io.metadata.samplingpointdata.SamplingPointDataGenerator;
import org.openforis.collect.manager.SamplingDesignManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.SurveyObjectsGenerator;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.metamodel.SimpleSurveyCreationParameters;
import org.openforis.collect.metamodel.samplingdesign.SamplingPointGenerationSettings;
import org.openforis.collect.metamodel.ui.UIConfiguration;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UIOptionsMigrator;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.metamodel.ui.UITabSet;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SamplingDesignItem;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.persistence.SurveyImportException;
import org.openforis.collect.persistence.SurveyStoreException;
import org.openforis.collect.persistence.xml.CeoApplicationOptions;
import org.openforis.collect.utils.SurveyObjects;
import org.openforis.idm.geospatial.CoordinateOperations;
import org.openforis.idm.metamodel.ApplicationOptions;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListLabel;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.metamodel.TextAttributeDefinition;

public class SurveyCreator {
    private SurveyManager surveyManager;
    private SamplingDesignManager samplingDesignManager;
    private UserGroupManager userGroupManager;
    private CoordinateOperations coordinateOperations;
    private String languageCode = Locale.ENGLISH.getLanguage();
    private String singleAttributeSurveyRootEntityName = "plot";
    private String singleAttributeSurveyKeyAttributeName = "plot_id";
    private String singleAttributeSurveyTabLabel = "Plot";
    private String singleAttributeSurveySecondLevelEntityName = "subplot";
    private String singleAttributeSurveySecondLevelIdAttributeName = "subplot_id";
    private String singleAttributeSurveyOperatorAttributeName = "operator";
    private String singleAttributeSurveyOperatorAttributeLabel = "Operator";

    public SurveyCreator(SurveyManager surveyManager, SamplingDesignManager samplingDesignManager, UserGroupManager userGroupManager, CoordinateOperations coordinateOperations) {
        this.surveyManager = surveyManager;
        this.samplingDesignManager = samplingDesignManager;
        this.userGroupManager = userGroupManager;
        this.coordinateOperations = coordinateOperations;
    }

    public CollectSurvey generateSimpleSurvey(SimpleSurveyCreationParameters parameters) throws SurveyStoreException, SurveyImportException {
        String projectName = parameters.getProjectName();
        String internalName = (String)ObjectUtils.defaultIfNull((Object)parameters.getName(), (Object)SurveyObjects.adjustInternalName((String)projectName));
        CollectSurvey existingSurvey = this.surveyManager.get(internalName);
        if (existingSurvey != null) {
            throw new IllegalArgumentException(String.format("Survey with name %s already existing", internalName));
        }
        CollectSurvey survey = this.createTemporarySimpleSurvey(internalName, parameters.getCodeLists());
        survey.setProjectName(survey.getDefaultLanguage(), projectName);
        survey.setDescription(survey.getDefaultLanguage(), parameters.getDescription());
        UserGroup userGroup = (UserGroup)this.userGroupManager.loadById((Object)parameters.getUserGroupId());
        survey.setUserGroup(userGroup);
        CeoApplicationOptions ceoApplicationOptions = new CeoApplicationOptions();
        ceoApplicationOptions.setBaseMapSource(parameters.getCeoSettings().getBaseMapSource());
        ceoApplicationOptions.setImageryYear(Integer.valueOf(parameters.getCeoSettings().getImageryYear()));
        ceoApplicationOptions.setStackingProfile(parameters.getCeoSettings().getStackingProfile());
        SamplingPointGenerationSettings samplingPointGenerationSettings = parameters.getSamplingPointGenerationSettings();
        ceoApplicationOptions.setSamplingPointDataConfiguration(samplingPointGenerationSettings);
        survey.addApplicationOptions((ApplicationOptions)ceoApplicationOptions);
        this.surveyManager.save(survey);
        SamplingPointDataGenerator generator = new SamplingPointDataGenerator(this.coordinateOperations, survey, parameters.getSamplingPointsByLevel(), samplingPointGenerationSettings);
        List<SamplingDesignItem> items = generator.generate();
        this.samplingDesignManager.insert(survey, items, true);
        return survey;
    }

    private CollectSurvey createTemporarySimpleSurvey(String name, List<SimpleSurveyCreationParameters.SimpleCodeList> simpleCodeLists) {
        CollectSurvey survey = this.surveyManager.createTemporarySurvey(name, this.languageCode);
        for (int codeListIdx = 0; codeListIdx < simpleCodeLists.size(); ++codeListIdx) {
            SimpleSurveyCreationParameters.SimpleCodeList simpleCodeList = simpleCodeLists.get(codeListIdx);
            CodeList codeList = survey.createCodeList();
            codeList.setName("values_" + (codeListIdx + 1));
            codeList.setLabel(CodeListLabel.Type.ITEM, survey.getDefaultLanguage(), simpleCodeList.getName());
            List items = simpleCodeList.getItems();
            for (int itemIdx = 0; itemIdx < items.size(); ++itemIdx) {
                SimpleSurveyCreationParameters.ListItem paramItem = (SimpleSurveyCreationParameters.ListItem)items.get(itemIdx);
                CodeListItem item = codeList.createItem(1);
                item.setCode((String)ObjectUtils.defaultIfNull((Object)paramItem.getCode(), (Object)String.valueOf(itemIdx + 1)));
                item.setLabel(this.languageCode, paramItem.getLabel());
                item.setColor(paramItem.getColor());
                codeList.addItem(item);
            }
            survey.addCodeList(codeList);
        }
        Schema schema = survey.getSchema();
        EntityDefinition rootEntityDef = schema.createEntityDefinition();
        rootEntityDef.setName(this.singleAttributeSurveyRootEntityName);
        schema.addRootEntityDefinition(rootEntityDef);
        CodeAttributeDefinition idAttrDef = schema.createCodeAttributeDefinition();
        idAttrDef.setName(this.singleAttributeSurveyKeyAttributeName);
        idAttrDef.setKey(true);
        idAttrDef.setList(survey.getSamplingDesignCodeList());
        rootEntityDef.addChildDefinition((NodeDefinition)idAttrDef);
        TextAttributeDefinition operatorAttrDef = schema.createTextAttributeDefinition();
        operatorAttrDef.setName(this.singleAttributeSurveyOperatorAttributeName);
        operatorAttrDef.setKey(true);
        operatorAttrDef.setLabel(NodeLabel.Type.INSTANCE, this.languageCode, this.singleAttributeSurveyOperatorAttributeLabel);
        survey.getAnnotations().setMeasurementAttribute((AttributeDefinition)operatorAttrDef, true);
        rootEntityDef.addChildDefinition((NodeDefinition)operatorAttrDef);
        EntityDefinition secondLevelEntityDef = schema.createEntityDefinition();
        secondLevelEntityDef.setName(this.singleAttributeSurveySecondLevelEntityName);
        secondLevelEntityDef.setMultiple(true);
        rootEntityDef.addChildDefinition((NodeDefinition)secondLevelEntityDef);
        CodeAttributeDefinition secondLevelIdAttrDef = schema.createCodeAttributeDefinition();
        secondLevelIdAttrDef.setName(this.singleAttributeSurveySecondLevelIdAttributeName);
        secondLevelIdAttrDef.setKey(true);
        secondLevelIdAttrDef.setList(survey.getSamplingDesignCodeList());
        secondLevelIdAttrDef.setParentCodeAttributeDefinition(idAttrDef);
        secondLevelEntityDef.addChildDefinition((NodeDefinition)secondLevelIdAttrDef);
        for (int i = 0; i < simpleCodeLists.size(); ++i) {
            String codeListName = "values_" + (i + 1);
            CodeList codeList = survey.getCodeList(codeListName);
            CodeAttributeDefinition valueAttrDef = schema.createCodeAttributeDefinition();
            valueAttrDef.setName(codeListName);
            valueAttrDef.setList(codeList);
            secondLevelEntityDef.addChildDefinition((NodeDefinition)valueAttrDef);
        }
        UIOptions uiOptions = survey.getUIOptions();
        UITabSet rootTabSet = uiOptions.createRootTabSet(rootEntityDef);
        UITab mainTab = uiOptions.getMainTab(rootTabSet);
        mainTab.setLabel(this.languageCode, this.singleAttributeSurveyTabLabel);
        UIConfiguration uiConfiguration = new UIOptionsMigrator().migrateToUIConfiguration(uiOptions);
        survey.setUIConfiguration(uiConfiguration);
        SurveyObjectsGenerator surveyObjectsGenerator = new SurveyObjectsGenerator();
        surveyObjectsGenerator.addPredefinedObjects((Survey)survey);
        if (survey.getSamplingDesignCodeList() == null) {
            survey.addSamplingDesignCodeList();
        }
        return survey;
    }
}

