/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.concurrency.SurveyLockingJob;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingChainExectutorTask;
import org.openforis.collect.datacleansing.DataCleansingReport;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.DataCleansingStepValue;
import org.openforis.collect.datacleansing.manager.DataCleansingReportManager;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordUpdater;
import org.openforis.collect.model.User;
import org.openforis.collect.persistence.jooq.JooqDaoSupport;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.FieldDefinition;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.Field;
import org.openforis.idm.model.Node;
import org.openforis.idm.model.Value;
import org.openforis.idm.model.expression.ExpressionEvaluator;
import org.openforis.idm.model.expression.InvalidExpressionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DataCleansingChainExecutorJob
extends SurveyLockingJob {
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private DataCleansingReportManager reportManager;
    private DataCleansingChain chain;
    private CollectRecord.Step recordStep;
    private User activeUser;

    protected void buildTasks() throws Throwable {
        DataCleansingChainExectutorTask task = (DataCleansingChainExectutorTask)this.addTask(DataCleansingChainExectutorTask.class);
        task.setInput(new DataCleansingChainExectutorTask.DataCleansingChainExecutorTaskInput(this.chain, this.recordStep, new DataCleansingChainNodeProcessor(this.chain)));
    }

    protected void onCompleted() {
        super.onCompleted();
        DataCleansingChainExectutorTask task = this.getChainExecutorTask();
        if (this.chain.getId() != null) {
            DataCleansingReport report = new DataCleansingReport(this.survey);
            report.setDatasetSize(task.getDatasetSize());
            report.setRecordStep(this.recordStep);
            report.setLastRecordModifiedDate(task.getLastRecordModifiedDate());
            report.setCleansingChainId((Integer)this.chain.getId());
            report.setCleansedRecords(task.getCleansedRecords());
            report.setCleansedNodes(task.getCleansedNodes());
            this.reportManager.save(report, this.activeUser);
        }
    }

    public void setChain(DataCleansingChain chain) {
        this.chain = chain;
        this.survey = (CollectSurvey)chain.getSurvey();
    }

    public void setRecordStep(CollectRecord.Step recordStep) {
        this.recordStep = recordStep;
    }

    public void setActiveUser(User activeUser) {
        this.activeUser = activeUser;
    }

    private DataCleansingChainExectutorTask getChainExecutorTask() {
        DataCleansingChainExectutorTask task = this.getTasks().isEmpty() ? null : (DataCleansingChainExectutorTask)((Object)this.getTasks().get(0));
        return task;
    }

    public int getUpdatedRecords() {
        DataCleansingChainExectutorTask task = this.getChainExecutorTask();
        return task == null ? 0 : task.getCleansedRecords();
    }

    public int getProcessedNodes() {
        DataCleansingChainExectutorTask task = this.getChainExecutorTask();
        return task == null ? 0 : task.getCleansedNodes();
    }

    private class DataCleansingChainNodeProcessor
    implements DataCleansingChainExectutorTask.DataCleansingStepNodeProcessor {
        private DataCleansingChain chain;
        private CollectRecord lastRecord;
        private RecordUpdater recordUpdater;
        private JooqDaoSupport.CollectStoreQueryBuffer queryBuffer;

        public DataCleansingChainNodeProcessor(DataCleansingChain chain) {
            this.chain = chain;
            this.recordUpdater = new RecordUpdater();
            this.queryBuffer = new JooqDaoSupport.CollectStoreQueryBuffer();
        }

        @Override
        public DataCleansingChainExectutorTask.DataCleansingStepNodeProcessorResult process(DataCleansingStep step, Node<?> node) throws Exception {
            switch (step.getType()) {
                case ATTRIBUTE_UPDATE: {
                    if (!(node instanceof Attribute)) {
                        throw new IllegalArgumentException("Invalid node type for attribute update: " + node.getClass().getName());
                    }
                    Attribute attrib = (Attribute)node;
                    AttributeDefinition attrDefn = (AttributeDefinition)attrib.getDefinition();
                    CollectRecord record = (CollectRecord)node.getRecord();
                    ExpressionEvaluator expressionEvaluator = record.getSurveyContext().getExpressionEvaluator();
                    DataCleansingStepValue stepValue = this.determineApplicableValue(step, attrib);
                    if (stepValue == null) {
                        return null;
                    }
                    switch (stepValue.getUpdateType()) {
                        case ATTRIBUTE: {
                            Value val = expressionEvaluator.evaluateAttributeValue((Node)attrib.getParent(), (Node)attrib, attrDefn, stepValue.getFixExpression());
                            this.recordUpdater.updateAttribute(attrib, val);
                            break;
                        }
                        case FIELD: {
                            List<String> fieldFixExpressions = stepValue.getFieldFixExpressions();
                            List fieldDefinitions = attrDefn.getFieldDefinitions();
                            for (int fieldIdx = 0; fieldIdx < fieldFixExpressions.size() && fieldIdx < fieldDefinitions.size(); ++fieldIdx) {
                                String fieldFixExpression = fieldFixExpressions.get(fieldIdx);
                                if (!StringUtils.isNotBlank((CharSequence)fieldFixExpression)) continue;
                                FieldDefinition fieldDefn = (FieldDefinition)fieldDefinitions.get(fieldIdx);
                                Object value = expressionEvaluator.evaluateFieldValue((Node)attrib.getParent(), (Node)attrib, fieldDefn, fieldFixExpression);
                                Field field = attrib.getField(fieldIdx);
                                this.recordUpdater.updateField(field, value);
                            }
                            break;
                        }
                    }
                    this.appendRecordUpdate(record);
                    return DataCleansingChainExectutorTask.DataCleansingStepNodeProcessorResult.ATTRIBUTE_UPDATED;
                }
                case ENTITY_DELETE: {
                    this.recordUpdater.deleteNode((Node)node.getParent());
                    return DataCleansingChainExectutorTask.DataCleansingStepNodeProcessorResult.ENTITY_DELETED;
                }
                case RECORD_DELETE: {
                    return DataCleansingChainExectutorTask.DataCleansingStepNodeProcessorResult.RECORD_TO_BE_DELETED;
                }
            }
            return null;
        }

        private DataCleansingStepValue determineApplicableValue(DataCleansingStep step, Attribute<?, Value> attrib) throws InvalidExpressionException {
            List<DataCleansingStepValue> values = step.getUpdateValues();
            for (DataCleansingStepValue stepValue : values) {
                if (StringUtils.isBlank((CharSequence)stepValue.getCondition())) {
                    return stepValue;
                }
                if (!this.evaluateCondition(attrib, stepValue)) continue;
                return stepValue;
            }
            throw new IllegalStateException("Cannot find a default applicable cleansing step value for cleansing step with id " + this.chain.getId());
        }

        private boolean evaluateCondition(Attribute<?, Value> attrib, DataCleansingStepValue stepValue) throws InvalidExpressionException {
            ExpressionEvaluator expressionEvaluator = this.chain.getSurvey().getContext().getExpressionEvaluator();
            boolean result = expressionEvaluator.evaluateBoolean((Node)attrib.getParent(), attrib, stepValue.getCondition());
            return result;
        }

        @Override
        public void close() {
            if (this.lastRecord != null) {
                this.appendLastRecordUpdate();
            }
            DataCleansingChainExecutorJob.this.recordManager.execute(this.queryBuffer.flush());
        }

        private void appendRecordUpdate(CollectRecord record) {
            if (this.lastRecord != null && !this.lastRecord.getId().equals(record.getId())) {
                this.appendLastRecordUpdate();
            }
            this.lastRecord = record;
        }

        private void appendLastRecordUpdate() {
            this.appendRecordUpdateQuery(this.lastRecord, this.lastRecord.getDataStep(), this.lastRecord.getDataWorkflowSequenceNumber());
        }

        private void appendRecordUpdateQuery(CollectRecord record, CollectRecord.Step step, int dataSequenceNumber) {
            record.updateSummaryFields();
            this.queryBuffer.append(DataCleansingChainExecutorJob.this.recordManager.createDataUpdateQuery(record, record.getId().intValue(), step, dataSequenceNumber));
        }
    }
}

