/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.UUID;
import org.openforis.collect.datacleansing.DataCleansingMetadata;
import org.openforis.collect.datacleansing.DataCleansingMetadataView;
import org.openforis.collect.datacleansing.io.DataCleansingExportTask;
import org.openforis.collect.datacleansing.manager.DataCleansingMetadataManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.concurrency.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class JsonDataCleansingExportTask
extends Task
implements DataCleansingExportTask {
    @Autowired
    private DataCleansingMetadataManager dataCleansingManager;
    private CollectSurvey survey;
    private File resultFile;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.resultFile = File.createTempFile("datacleansing_metadata", ".json");
    }

    protected void execute() throws Throwable {
        DataCleansingMetadata metadata = this.dataCleansingManager.loadMetadata(this.survey);
        if (!metadata.isEmpty()) {
            DataCleansingMetadataView metadataView = DataCleansingMetadataView.fromMetadata(metadata);
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(this.resultFile, (Object)metadataView);
        }
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public File getResultFile() {
        return this.resultFile;
    }

    public static void main(String[] args) {
        System.out.println(UUID.randomUUID().toString());
    }
}

