/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.openforis.collect.datacleansing.DataCleansingMetadata;
import org.openforis.collect.datacleansing.DataCleansingMetadataView;
import org.openforis.collect.datacleansing.io.DataCleansingImportTask;
import org.openforis.collect.datacleansing.manager.DataCleansingMetadataManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.concurrency.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class JsonDataCleansingImportTask
extends Task
implements DataCleansingImportTask {
    @Autowired
    private DataCleansingMetadataManager dataCleansingManager;
    private CollectSurvey survey;
    private File inputFile;
    private User activeUser;

    protected void execute() throws Throwable {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DataCleansingMetadataView metadataView = (DataCleansingMetadataView)objectMapper.readValue(this.inputFile, DataCleansingMetadataView.class);
        DataCleansingMetadata metadata = metadataView.toMetadata(this.survey);
        this.dataCleansingManager.saveMetadata(this.survey, metadata, true, this.activeUser);
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setActiveUser(User activeUser) {
        this.activeUser = activeUser;
    }
}

