/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.manager;

import java.util.List;
import java.util.Locale;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryType;
import org.openforis.collect.datacleansing.manager.DataQueryManager;
import org.openforis.collect.datacleansing.persistence.DataQueryTypeDao;
import org.openforis.collect.manager.AbstractSurveyObjectManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="dataQueryTypeManager")
public class DataQueryTypeManager
extends AbstractSurveyObjectManager<Integer, DataQueryType, DataQueryTypeDao> {
    @Autowired
    private DataQueryManager dataQueryManager;
    @Autowired
    private MessageSource messageSource;

    public DataQueryType loadByCode(CollectSurvey survey, String code) {
        return ((DataQueryTypeDao)this.dao).loadByCode(survey, code);
    }

    public void delete(DataQueryType obj) {
        DataQueryType errorType = (DataQueryType)this.loadById((CollectSurvey)obj.getSurvey(), (Integer)obj.getId());
        this.checkNotInUse(errorType);
        super.delete((PersistedSurveyObject)errorType);
    }

    private void checkNotInUse(DataQueryType errorType) {
        List<DataQuery> dataQueries = this.dataQueryManager.loadByType(errorType);
        if (!dataQueries.isEmpty()) {
            String message = this.messageSource.getMessage("data_query_type.delete.error.used_by_query", (Object[])new String[]{errorType.getCode()}, Locale.ENGLISH);
            throw new IllegalStateException(message);
        }
    }
}

