/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.persistence;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableLike;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingReport;
import org.openforis.collect.datacleansing.persistence.DataCleansingItemDao;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.persistence.jooq.Sequences;
import org.openforis.collect.persistence.jooq.SurveyObjectMappingDSLContext;
import org.openforis.collect.persistence.jooq.tables.OfcDataCleansingChain;
import org.openforis.collect.persistence.jooq.tables.OfcDataCleansingReport;
import org.openforis.collect.persistence.jooq.tables.records.OfcDataCleansingReportRecord;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dataCleansingReportDao")
@Transactional
public class DataCleansingReportDao
extends DataCleansingItemDao<DataCleansingReport, JooqDSLContext> {
    public DataCleansingReportDao() {
        super(JooqDSLContext.class);
    }

    public List<DataCleansingReport> loadBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectConditionStep select = dsl.select((SelectField[])OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.fields()).from((TableLike)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT).join((TableLike)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN).on(new Condition[]{OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.ID.eq((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSING_CHAIN_ID)}).where(new Condition[]{OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.SURVEY_ID.eq((Object)survey.getId())});
        return dsl.fromResult(select.fetch());
    }

    public void deleteBySurvey(CollectSurvey survey) {
        ((JooqDSLContext)this.dsl()).delete((Table)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT).where(new Condition[]{OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSING_CHAIN_ID.in((Select)((JooqDSLContext)this.dsl()).select((SelectField)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.ID).from((TableLike)OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN).where(new Condition[]{OfcDataCleansingChain.OFC_DATA_CLEANSING_CHAIN.SURVEY_ID.eq((Object)survey.getId())}))}).execute();
    }

    public List<DataCleansingReport> loadByCleansingChain(DataCleansingChain cleansingChain) {
        CollectSurvey survey = (CollectSurvey)cleansingChain.getSurvey();
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectSeekStep1 select = dsl.selectFrom((Table)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT).where(new Condition[]{OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSING_CHAIN_ID.eq((Object)((Integer)cleansingChain.getId()))}).orderBy((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CREATION_DATE);
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    public DataCleansingReport loadLastReport(DataCleansingChain cleansingChain) {
        CollectSurvey survey = (CollectSurvey)cleansingChain.getSurvey();
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectSeekStep1 select = dsl.selectFrom((Table)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT).where(new Condition[]{OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSING_CHAIN_ID.eq((Object)((Integer)cleansingChain.getId()))}).orderBy(OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CREATION_DATE.desc());
        OfcDataCleansingReportRecord record = (OfcDataCleansingReportRecord)select.fetchAny();
        return record == null ? null : (DataCleansingReport)((Object)dsl.fromRecord((Record)record));
    }

    public void deleteByCleansingChain(DataCleansingChain chain) {
        CollectSurvey survey = (CollectSurvey)chain.getSurvey();
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        dsl.deleteFrom((Table)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT).where(new Condition[]{OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSING_CHAIN_ID.eq((Object)((Integer)chain.getId()))}).execute();
    }

    protected static class JooqDSLContext
    extends SurveyObjectMappingDSLContext<Integer, DataCleansingReport> {
        private static final long serialVersionUID = 1L;

        public JooqDSLContext(Configuration config) {
            this(config, null);
        }

        public JooqDSLContext(Configuration config, CollectSurvey survey) {
            super(config, OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.ID, Sequences.OFC_DATA_CLEANSING_REPORT_ID_SEQ, DataCleansingReport.class, survey);
        }

        protected DataCleansingReport newEntity() {
            return new DataCleansingReport(this.survey);
        }

        protected void fromRecord(Record r, DataCleansingReport o) {
            super.fromRecord(r, (PersistedSurveyObject)o);
            o.setCleansedNodes((Integer)r.getValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSED_NODES));
            o.setCleansedRecords((Integer)r.getValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSED_RECORDS));
            o.setCleansingChainId((Integer)r.getValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSING_CHAIN_ID));
            o.setCreationDate((Date)r.getValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CREATION_DATE));
            o.setDatasetSize((Integer)r.getValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.DATASET_SIZE));
            o.setLastRecordModifiedDate((Date)r.getValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.LAST_RECORD_MODIFIED_DATE));
            o.setRecordStep(CollectRecord.Step.valueOf((int)((Integer)r.getValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.RECORD_STEP))));
            o.setUuid(UUID.fromString((String)r.getValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.UUID)));
        }

        protected void fromObject(DataCleansingReport o, StoreQuery<?> q) {
            super.fromObject((PersistedSurveyObject)o, q);
            q.addValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSED_NODES, (Object)o.getCleansedNodes());
            q.addValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSED_RECORDS, (Object)o.getCleansedRecords());
            q.addValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CLEANSING_CHAIN_ID, (Object)o.getCleansingChainId());
            q.addValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.CREATION_DATE, (Object)DataCleansingReportDao.toTimestamp((Date)o.getCreationDate()));
            q.addValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.DATASET_SIZE, (Object)o.getDatasetSize());
            q.addValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.LAST_RECORD_MODIFIED_DATE, (Object)DataCleansingReportDao.toTimestamp((Date)o.getLastRecordModifiedDate()));
            q.addValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.RECORD_STEP, (Object)o.getRecordStep().getStepNumber());
            q.addValue((Field)OfcDataCleansingReport.OFC_DATA_CLEANSING_REPORT.UUID, (Object)o.getUuid().toString());
        }
    }
}

