/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.data;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.event.EventListener;
import org.openforis.collect.event.EventProducer;
import org.openforis.collect.event.EventQueue;
import org.openforis.collect.event.RecordEvent;
import org.openforis.collect.event.RecordTransaction;
import org.openforis.collect.manager.MessageSource;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.NodeChangeBatchProcessor;
import org.openforis.collect.model.NodeChangeSet;
import org.springframework.beans.factory.annotation.Autowired;

public class RecordEventBatchPublisher
implements EventListener,
NodeChangeBatchProcessor {
    @Autowired
    private MessageSource messageSource;
    private List<RecordEvent> events = new ArrayList<RecordEvent>();
    private EventQueue eventQueue;

    public RecordEventBatchPublisher(EventQueue eventQueue) {
        this.eventQueue = eventQueue;
    }

    public void onEvent(RecordEvent event) {
        if (!this.eventQueue.isEnabled()) {
            return;
        }
        this.events.add(event);
    }

    public void add(NodeChangeSet nodeChanges, String userName) {
        if (!this.eventQueue.isEnabled()) {
            return;
        }
        EventProducer.EventProducerContext context = new EventProducer.EventProducerContext(this.messageSource, userName);
        new EventProducer(context, (EventListener)this).produceFor(nodeChanges);
    }

    public void process(CollectRecord record) {
        if (!this.eventQueue.isEnabled()) {
            return;
        }
        if (!this.events.isEmpty()) {
            this.initializeEvents(record);
            String surveyName = record.getSurvey().getName();
            this.eventQueue.publish(new RecordTransaction(surveyName, record.getId().intValue(), record.getStep().toRecordStep(), this.events));
            this.events.clear();
        }
    }

    private void initializeEvents(CollectRecord record) {
        for (RecordEvent recordEvent : this.events) {
            if (recordEvent.getRecordId() != null) continue;
            recordEvent.initializeRecordId(record.getId().intValue());
        }
    }
}

