/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.web.session.SessionState;
import org.openforis.collect.web.ws.AppWS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UnlockController {
    private static final Logger LOG = LogManager.getLogger(UnlockController.class);
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private AppWS appWS;

    @RequestMapping(value={"/clearActiveRecord.htm"}, method={RequestMethod.POST})
    @ResponseBody
    public String clearActiveRecord(HttpServletRequest request) {
        try {
            CollectRecord activeRecord;
            SessionState sessionState;
            HttpSession session = request.getSession();
            if (session != null && (sessionState = (SessionState)session.getAttribute(SessionState.SESSION_ATTRIBUTE_NAME)) != null && (activeRecord = sessionState.getActiveRecord()) != null) {
                Integer recordId = activeRecord.getId();
                if (recordId != null) {
                    this.recordManager.releaseLock(recordId);
                    this.appWS.sendMessage(new AppWS.RecordUnlockedMessage(recordId));
                }
                sessionState.setActiveRecord(null);
            }
            return "ok";
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

