/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.manager.MessageSource;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.ValidationReportProcess;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserRole;
import org.openforis.collect.model.validation.ValidationMessageBuilder;
import org.openforis.collect.spring.SpringMessageSource;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.utils.Dates;
import org.openforis.collect.web.controller.BasicController;
import org.openforis.collect.web.session.SessionState;
import org.openforis.commons.collection.Visitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ValidationController
extends BasicController {
    private static final Logger LOG = LogManager.getLogger(ValidationController.class);
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private SpringMessageSource messageContextHolder;

    @RequestMapping(value={"/validateAllRecords.htm"}, method={RequestMethod.GET})
    public void validateAllRecords(HttpServletRequest request, HttpServletResponse response, @RequestParam String s, @RequestParam String r) throws IOException {
        final ServletOutputStream outputStream = response.getOutputStream();
        try {
            if (s == null || r == null) {
                outputStream.println("Wrong parameters: please specify 's' (survey) and 'r' (root entity name).");
                return;
            }
            SessionState sessionState = this.getSessionState(request);
            final User user = sessionState.getUser();
            final String sessionId = sessionState.getSessionId();
            this.print(outputStream, "Starting validation of all records: ");
            final CollectSurvey survey = this.surveyManager.get(s);
            if (survey == null) {
                this.print(outputStream, "Survey not found");
                return;
            }
            RecordFilter filter = new RecordFilter(survey);
            filter.setRootEntityId(Integer.valueOf(survey.getSchema().getRootEntityDefinition(r).getId()));
            final ValidationMessageBuilder validationMessageHelper = ValidationMessageBuilder.createInstance((MessageSource)this.messageContextHolder);
            this.recordManager.visitSummaries(filter, null, (Visitor)new Visitor<CollectRecordSummary>(){

                public void visit(CollectRecordSummary summary) {
                    try {
                        String recordKey = validationMessageHelper.getRecordKey(summary);
                        long start = System.currentTimeMillis();
                        ValidationController.this.print(outputStream, "Start validating record: " + recordKey);
                        Integer id = summary.getId();
                        CollectRecord.Step step = summary.getStep();
                        ValidationController.this.recordManager.validateAndSave(survey, user, sessionId, id.intValue(), step);
                        long elapsedMillis = System.currentTimeMillis() - start;
                        ValidationController.this.print(outputStream, "Validation of record " + recordKey + " completed in " + elapsedMillis + " millis");
                    }
                    catch (Exception e) {
                        try {
                            String message = "ERROR validating record " + summary.getId();
                            outputStream.println(message);
                            LOG.error(message);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.print(outputStream, "End of validation of all records.");
        }
        catch (Exception e) {
            outputStream.println("ERROR - Validation of records not completed: " + e.getMessage());
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/validationReport"}, method={RequestMethod.GET})
    public void validationReport(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false) String surveyName, @RequestParam(required=false) Integer rootEntityId, @RequestParam(required=false, defaultValue="en_US") String locale, String[] recordKeys, @RequestParam(required=false) Date modifiedSince) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            if (surveyName == null || rootEntityId == null || locale == null) {
                outputStream.println("Wrong parameters: please specify 'surveyName' (name of the survey), 'rootEntityId' (root entity id) and 'locale' string rappresentation of locale");
                return;
            }
            CollectSurvey survey = this.surveyManager.get(surveyName);
            if (survey == null) {
                this.print(outputStream, "Survey not found");
                return;
            }
            String outputFileName = String.format("%s_validation_report_%s.csv", surveyName, Dates.formatDateTime((Date)new Date()));
            Controllers.setOutputContent(response, outputFileName, "text/csv");
            SessionState sessionState = this.getSessionState(request);
            User user = sessionState.getUser();
            String sessionId = sessionState.getSessionId();
            RecordFilter recordFilter = new RecordFilter(survey, rootEntityId);
            recordFilter.setKeyValues(recordKeys);
            recordFilter.setModifiedSince(modifiedSince);
            if (user.getRole() == UserRole.ENTRY_LIMITED) {
                recordFilter.setOwnerId(user.getId().intValue());
            }
            ValidationReportProcess process = new ValidationReportProcess((OutputStream)outputStream, this.recordManager, this.messageContextHolder, ValidationReportProcess.ReportType.CSV, user, sessionId, recordFilter, true, LocaleUtils.toLocale((String)locale));
            process.init();
            process.call();
        }
        catch (Exception e) {
            LOG.error("ERROR - Validation of records not completed: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void print(ServletOutputStream outputStream, String message) throws IOException {
        outputStream.println(message);
        outputStream.flush();
        LOG.info(message);
    }
}

