/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.openforis.collect.designer.form.AttributeDefinitionFormObject;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.TextAttributeDefinition;

public class TextAttributeDefinitionFormObject<T extends TextAttributeDefinition>
extends AttributeDefinitionFormObject<T> {
    private String type;
    private String input;
    private String autocompleteGroup;
    private boolean autoUppercase;
    private boolean geometry;

    TextAttributeDefinitionFormObject(EntityDefinition parentDefn) {
        super(parentDefn);
        TextAttributeDefinition.Type.SHORT.name();
    }

    @Override
    public void saveTo(T dest, String languageCode) {
        super.saveTo(dest, languageCode);
        TextAttributeDefinition.Type typeEnum = TextAttributeDefinition.Type.valueOf((String)this.type);
        dest.setType(typeEnum);
        dest.setAnnotation(CollectAnnotations.Annotation.AUTOCOMPLETE.getQName(), this.autocompleteGroup);
        UIOptions uiOptions = this.getUIOptions((NodeDefinition)dest);
        uiOptions.setAutoUppercase(dest, this.autoUppercase);
        CollectAnnotations annotations = ((CollectSurvey)dest.getSurvey()).getAnnotations();
        CollectAnnotations.TextInput textInput = CollectAnnotations.TextInput.valueOf((String)this.input);
        annotations.setTextInput(dest, textInput);
        annotations.setGeometry(dest, this.geometry);
    }

    @Override
    public void loadFrom(T source, String languageCode) {
        super.loadFrom(source, languageCode);
        TextAttributeDefinition.Type typeEnum = source.getType();
        if (typeEnum == null) {
            typeEnum = TextAttributeDefinition.Type.SHORT;
        }
        this.type = typeEnum.name();
        this.autocompleteGroup = source.getAnnotation(CollectAnnotations.Annotation.AUTOCOMPLETE.getQName());
        UIOptions uiOptions = this.getUIOptions((NodeDefinition)source);
        this.autoUppercase = uiOptions.isAutoUppercase(source);
        CollectAnnotations annotations = ((CollectSurvey)source.getSurvey()).getAnnotations();
        CollectAnnotations.TextInput textInput = annotations.getTextInput(source);
        this.input = textInput.name();
        this.geometry = annotations.isGeometry(source);
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAutocompleteGroup() {
        return this.autocompleteGroup;
    }

    public void setAutocompleteGroup(String autocompleteGroup) {
        this.autocompleteGroup = autocompleteGroup;
    }

    public boolean isAutoUppercase() {
        return this.autoUppercase;
    }

    public void setAutoUppercase(boolean autoUppercase) {
        this.autoUppercase = autoUppercase;
    }

    public boolean isGeometry() {
        return this.geometry;
    }

    public void setGeometry(boolean geometry) {
        this.geometry = geometry;
    }
}

