/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.reporting;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.openforis.collect.manager.BaseStorageManager;
import org.openforis.collect.model.Configuration;
import org.openforis.collect.utils.Dates;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class MondrianSchemaStorageManager
extends BaseStorageManager
implements InitializingBean {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_STORAGE_SUBFOLDER = "rdb" + File.separator + "mondrian";

    public MondrianSchemaStorageManager() {
        super(DEFAULT_STORAGE_SUBFOLDER);
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void init() {
        this.initStorageDirectory();
    }

    protected void initStorageDirectory() {
        super.initStorageDirectory(Configuration.ConfigurationItem.MONDRIAN_SCHEMA_PATH);
    }

    public boolean existsSchemaFile(String surveyName) {
        File file = this.getSchemaFile(surveyName);
        return file.exists() && file.length() > 0L;
    }

    public boolean createBackupCopy(String surveyName) throws IOException {
        File file = this.getSchemaFile(surveyName);
        if (file.exists() && file.length() > 0L) {
            String newBackupFileName = String.format("%s.%s", this.getSchemaFileName(surveyName), Dates.formatDate((Date)new Date()));
            File backupFile = new File(this.getOrCreateBackupFolder(), newBackupFileName);
            FileUtils.copyFile((File)file, (File)backupFile);
            return true;
        }
        return false;
    }

    private File getOrCreateBackupFolder() {
        File parentDir = new File(this.storageDirectory, "backup");
        parentDir.mkdirs();
        return parentDir;
    }

    public File getSchemaFile(String surveyName) {
        return new File(this.storageDirectory, this.getSchemaFileName(surveyName));
    }

    public String readSchemaFile(String surveyName) {
        File schemaFile = this.getSchemaFile(surveyName);
        try {
            String xml = FileUtils.readFileToString((File)schemaFile, (String)"UTF-8");
            return xml;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading schema file for survey: " + surveyName, e);
        }
    }

    public boolean deleteSchemaFile(String surveyName) {
        File file = this.getSchemaFile(surveyName);
        return file.delete();
    }

    private String getSchemaFileName(String surveyName) {
        return String.format("%s.xml", surveyName);
    }
}

