/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.validator.FormValidator;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class AttributeDefaultFormValidator
extends FormValidator {
    private static final String PARENT_DEFINITION_ARG = "parentDefinition";
    protected static final String VALUE_OR_EXPRESSION_REQUIRED_MESSAGE_KEY = "survey.schema.attribute.attribute_default.validation.value_or_expression_required";
    protected static final String CANNOT_SPECIFY_BOTH_VALUE_AND_EXPRESSION_MESSAGE_KEY = "survey.schema.attribute.attribute_default.validation.cannot_specify_both_value_and_expression";
    protected static final String FIELD_REQUIRED_MESSAGE_KEY = "global.item.validation.required_field";
    protected static final String VALUE_FIELD = "value";
    protected static final String EXPRESSION_FIELD = "expression";
    protected static final String CONDITION_FIELD = "condition";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        this.validateCondition(ctx);
        this.validateValue(ctx);
        this.validateExpression(ctx);
    }

    private void validateCondition(ValidationContext ctx) {
        NodeDefinition contextNode = this.getContextNode(ctx);
        this.validateBooleanExpressionField(ctx, contextNode, CONDITION_FIELD);
    }

    private void validateValue(ValidationContext ctx) {
        String value = (String)this.getValue(ctx, VALUE_FIELD);
        String expression = (String)this.getValue(ctx, EXPRESSION_FIELD);
        if (StringUtils.isBlank((CharSequence)value) && StringUtils.isBlank((CharSequence)expression)) {
            this.addInvalidMessage(ctx, VALUE_FIELD, Labels.getLabel((String)VALUE_OR_EXPRESSION_REQUIRED_MESSAGE_KEY));
        } else if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)expression)) {
            this.addInvalidMessage(ctx, VALUE_FIELD, Labels.getLabel((String)CANNOT_SPECIFY_BOTH_VALUE_AND_EXPRESSION_MESSAGE_KEY));
        } else if (StringUtils.isNotBlank((CharSequence)value)) {
            AttributeDefinition contextNode = (AttributeDefinition)this.getContextNode(ctx);
            try {
                contextNode.createValue(value);
            }
            catch (Exception e) {
                this.addInvalidMessage(ctx, VALUE_FIELD, Labels.getLabel((String)"survey.validation.error.invalid_expression"));
            }
        }
    }

    private void validateExpression(ValidationContext ctx) {
        String value = (String)this.getValue(ctx, VALUE_FIELD);
        String expression = (String)this.getValue(ctx, EXPRESSION_FIELD);
        if (StringUtils.isBlank((CharSequence)value) && StringUtils.isBlank((CharSequence)expression)) {
            this.addInvalidMessage(ctx, EXPRESSION_FIELD, Labels.getLabel((String)VALUE_OR_EXPRESSION_REQUIRED_MESSAGE_KEY));
        } else if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)expression)) {
            this.addInvalidMessage(ctx, EXPRESSION_FIELD, Labels.getLabel((String)CANNOT_SPECIFY_BOTH_VALUE_AND_EXPRESSION_MESSAGE_KEY));
        } else {
            NodeDefinition contextNode = this.getContextNode(ctx);
            this.validateValueExpressionField(ctx, contextNode, EXPRESSION_FIELD);
        }
    }

    protected NodeDefinition getContextNode(ValidationContext ctx) {
        NodeDefinition result = (NodeDefinition)ctx.getValidatorArg(PARENT_DEFINITION_ARG);
        return result;
    }
}

