/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel.layout;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.metamodel.ui.UITabSet;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.VersionableSurveyObject;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Include;

public class TabsGroupPanelVM
extends BaseVM {
    @Wire
    private Include listOfNodesInclude;
    private UITab tab;

    @Init
    public void init(@ExecutionArgParam(value="tab") UITab tab) {
        this.tab = tab;
    }

    @AfterCompose
    public void afterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        Selectors.wireComponents((Component)view, (Object)this, (boolean)false);
        Selectors.wireEventListeners((Component)view, (Object)this);
    }

    @GlobalCommand
    public void nodeAssignedToTab(@BindingParam(value="oldTab") UITab oldTab, @BindingParam(value="newTab") UITab newTab) {
        if (oldTab != null && oldTab.equals((Object)this.tab) || newTab != null && newTab.equals((Object)this.tab)) {
            this.refreshListOfNodes();
        }
    }

    @GlobalCommand
    public void nodesPerTabChanged(@BindingParam(value="tab") UITabSet tab) {
        if (tab.equals((Object)this.tab)) {
            this.refreshListOfNodes();
        }
    }

    protected void refreshListOfNodes() {
        this.listOfNodesInclude.setSrc(null);
        List<NodeDefinition> nodesPerTab = this.getNodesPerTab();
        this.listOfNodesInclude.setDynamicProperty("tab", (Object)this.tab);
        this.listOfNodesInclude.setDynamicProperty("nodes", nodesPerTab);
        this.listOfNodesInclude.setSrc(Resources.Component.TABSGROUP_LIST_OF_NODES.getLocation());
    }

    public List<NodeDefinition> getNodesPerTab() {
        UIOptions uiOpts = this.getUIOptions();
        ArrayList<NodeDefinition> result = new ArrayList<NodeDefinition>();
        List nodesPerTab = uiOpts.getNodesPerTab(this.tab, false);
        ModelVersion version = this.getFormVersion();
        for (NodeDefinition nodeDefn : nodesPerTab) {
            if (version != null && !version.isApplicable((VersionableSurveyObject)nodeDefn)) continue;
            result.add(nodeDefn);
        }
        return result;
    }

    protected CollectSurvey getSurvey() {
        SessionStatus sessionStatus = super.getSessionStatus();
        CollectSurvey survey = sessionStatus.getSurvey();
        return survey;
    }

    public ModelVersion getFormVersion() {
        SessionStatus sessionStatus = super.getSessionStatus();
        ModelVersion version = sessionStatus.getLayoutFormVersion();
        return version;
    }

    protected UIOptions getUIOptions() {
        CollectSurvey survey = this.getSurvey();
        UIOptions uiConf = survey.getUIOptions();
        return uiConf;
    }

    public UITab getTab() {
        return this.tab;
    }
}

