/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.openforis.collect.designer.form.validator.BaseValidator;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.SurveySummary;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class SurveyNameValidator
extends BaseValidator {
    protected static final String DUPLICATE_NAME_MESSAGE_KEY = "survey.validation.error.duplicate_name";
    private SurveyManager surveyManager;
    private String surveyNameField;
    private boolean checkForDuplicates;

    public SurveyNameValidator(SurveyManager surveyManager, String surveyNameField, boolean checkForDuplicates) {
        this.surveyManager = surveyManager;
        this.surveyNameField = surveyNameField;
        this.checkForDuplicates = checkForDuplicates;
    }

    public void validate(ValidationContext ctx) {
        if (this.validateRequired(ctx, this.surveyNameField) && this.validateInternalName(ctx, this.surveyNameField) && this.checkForDuplicates) {
            this.validateNameUniqueness(ctx);
        }
    }

    private boolean validateNameUniqueness(ValidationContext ctx) {
        String name = (String)this.getValue(ctx, this.surveyNameField);
        SurveySummary existingSurveySummary = this.loadExistingSurveySummaryByName(ctx, name);
        if (existingSurveySummary == null) {
            return true;
        }
        this.addInvalidMessage(ctx, this.surveyNameField, Labels.getLabel((String)DUPLICATE_NAME_MESSAGE_KEY));
        return false;
    }

    private SurveySummary loadExistingSurveySummaryByName(ValidationContext ctx, String name) {
        SurveySummary summary = this.surveyManager.loadSummaryByName(name);
        return summary;
    }
}

