/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.Proxy;
import org.openforis.collect.ProxyContext;
import org.openforis.collect.manager.MessageSource;
import org.openforis.collect.model.validation.SpecifiedValidator;
import org.openforis.collect.model.validation.ValidationMessageBuilder;
import org.openforis.idm.metamodel.validation.ValidationResult;
import org.openforis.idm.metamodel.validation.ValidationResults;
import org.openforis.idm.model.Attribute;

public class ValidationResultsProxy
implements Proxy {
    private transient Attribute<?, ?> attribute;
    private transient ValidationResults validationResults;
    private transient ProxyContext context;

    public ValidationResultsProxy(ProxyContext context, Attribute<?, ?> attribute, ValidationResults validationResults) {
        this.context = context;
        this.attribute = attribute;
        this.validationResults = validationResults;
    }

    public List<String> getErrors() {
        return this.extractValidationResultMessages(this.validationResults.getErrors());
    }

    public List<String> getWarnings() {
        return this.extractValidationResultMessages(this.validationResults.getWarnings());
    }

    public boolean isSpecifiedErrorPresent() {
        List errors = this.validationResults.getErrors();
        for (ValidationResult validationResult : errors) {
            if (!(validationResult.getValidator() instanceof SpecifiedValidator)) continue;
            return true;
        }
        return false;
    }

    private List<String> extractValidationResultMessages(List<ValidationResult> validationResultList) {
        ArrayList<String> result = new ArrayList<String>();
        ValidationMessageBuilder validationMessageBuilder = ValidationMessageBuilder.createInstance((MessageSource)this.context.getMessageSource());
        for (ValidationResult validationResult : validationResultList) {
            result.add(validationMessageBuilder.getValidationMessage(this.attribute, validationResult, this.context.getLocale()));
        }
        return result;
    }
}

