/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.form.SurveyFileFormObject;
import org.openforis.collect.designer.util.MediaUtil;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.io.metadata.collectearth.CSVFileValidationResult;
import org.openforis.collect.io.metadata.collectearth.CollectEarthGridTemplateGenerator;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.validation.SurveyValidator;
import org.openforis.collect.model.SurveyFile;
import org.openforis.collect.utils.Dates;
import org.openforis.commons.collection.CollectionUtils;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Listitem;

public class SurveyFileVM
extends SurveyObjectBaseVM<SurveyFile> {
    private static final String APPLY_CHANGES_TO_EDITED_SURVEY_FILE_GLOBAL_COMMAND = "applyChangesToEditedSurveyFile";
    private static final String CLOSE_SURVEY_FILE_EDIT_POPUP_GLOBAL_COMMAND = "closeSurveyFileEditPopUp";
    @WireVariable
    private SurveyManager surveyManager;
    private List<File> uploadedFiles;
    private List<String> uploadedFileNames;
    private Map<String, String> form = new HashMap<String, String>();
    private Set<String> selectedUploadedFileNames = new HashSet<String>();

    public SurveyFileVM() {
        this.setCommitChangesOnApply(false);
        this.fieldLabelKeyPrefixes.addAll(0, Arrays.asList("survey.schema.attribute.attribute_default"));
    }

    @Init(superclass=false)
    public void init(@ContextParam(value=ContextType.BINDER) Binder binder, @ExecutionArgParam(value="surveyFile") SurveyFile surveyFile, @ExecutionArgParam(value="newItem") Boolean newItem) {
        super.init();
        this.newItem = newItem;
        this.setEditedItem(surveyFile);
        if (surveyFile != null && !newItem.booleanValue()) {
            this.validateForm(binder);
        }
    }

    @Override
    protected FormObject<SurveyFile> createFormObject() {
        return new SurveyFileFormObject();
    }

    @Override
    protected List<SurveyFile> getItemsInternal() {
        return null;
    }

    @Override
    protected SurveyFile createItemInstance() {
        return null;
    }

    @Override
    protected void addNewItemToSurvey() {
        if (this.isMultipleFilesUploaded()) {
            ArrayList<SurveyFile> surveyFiles = new ArrayList<SurveyFile>(this.uploadedFiles.size());
            for (String filename : this.uploadedFileNames) {
                SurveyFile surveyFile = new SurveyFile(this.survey);
                surveyFile.setType(((SurveyFile)this.editedItem).getType());
                surveyFile.setFilename(filename);
                surveyFiles.add(surveyFile);
            }
            this.surveyManager.addSurveyFiles(this.survey, surveyFiles, this.uploadedFiles);
        } else {
            this.surveyManager.addSurveyFile(this.survey, (SurveyFile)this.editedItem, this.uploadedFiles.get(0));
        }
    }

    @Override
    protected void deleteItemFromSurvey(SurveyFile item) {
    }

    @Override
    protected void moveSelectedItemInSurvey(int indexTo) {
    }

    @Command
    public void close() {
        BindUtils.postGlobalCommand(null, null, (String)CLOSE_SURVEY_FILE_EDIT_POPUP_GLOBAL_COMMAND, null);
    }

    @Override
    @Command
    public void commitChanges(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.dispatchApplyChangesCommand(binder);
        if (this.checkCanLeaveForm()) {
            if (this.newItem && (this.uploadedFiles == null || this.uploadedFiles.isEmpty())) {
                MessageUtil.showError("global.file_not_selected", new Object[0]);
            } else if (this.uploadedFiles == null || this.validateFileContent(binder)) {
                boolean wasNewItem = this.newItem;
                super.commitChanges(binder);
                if (!wasNewItem) {
                    File uploadedFile = this.uploadedFiles != null && !this.uploadedFiles.isEmpty() ? this.uploadedFiles.get(0) : null;
                    this.surveyManager.updateSurveyFile(this.survey, (SurveyFile)this.editedItem, uploadedFile);
                }
                BindUtils.postGlobalCommand(null, null, (String)APPLY_CHANGES_TO_EDITED_SURVEY_FILE_GLOBAL_COMMAND, null);
            }
        }
    }

    private boolean validateFileContent(Binder binder) {
        String typeName = (String)this.getFormFieldValue(binder, "type");
        SurveyFile.SurveyFileType type = SurveyFile.SurveyFileType.valueOf((String)typeName);
        switch (type) {
            case COLLECT_EARTH_GRID: {
                CollectEarthGridTemplateGenerator templateGenerator = new CollectEarthGridTemplateGenerator();
                for (File uploadedFile : this.uploadedFiles) {
                    CSVFileValidationResult headersValidationResult = templateGenerator.validate(uploadedFile, this.survey, new SurveyValidator.ValidationParameters());
                    if (headersValidationResult.isSuccessful()) continue;
                    switch (headersValidationResult.getErrorType()) {
                        case INVALID_FILE_TYPE: {
                            MessageUtil.showWarning("survey.file.error.invalid_file_type", "CSV (Comma Separated Values)");
                            break;
                        }
                        case INVALID_HEADERS: {
                            MessageUtil.showWarning("survey.file.type.collect_earth_grid.error.invalid_file_structure", headersValidationResult.getExpectedHeaders().toString(), headersValidationResult.getFoundHeaders().toString());
                            break;
                        }
                        case INVALID_NUMBER_OF_PLOTS_WARNING: {
                            MessageUtil.showWarning("survey.file.error.warning_csv_size", "2000");
                            break;
                        }
                        case INVALID_NUMBER_OF_PLOTS_TOO_LARGE: {
                            MessageUtil.showWarning("survey.file.error.error_csv_size", "4000");
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return true;
    }

    @Command
    public void fileUploaded(@ContextParam(value=ContextType.TRIGGER_EVENT) UploadEvent event, @ContextParam(value=ContextType.BINDER) Binder binder) {
        Media[] medias = event.getMedias();
        if (medias.length > 1 && !this.newItem) {
            MessageUtil.showWarning("survey.file.error.multiple_files_allowed_only_for_new_survey_file", new Object[0]);
            return;
        }
        this.uploadedFiles = new ArrayList<File>();
        this.uploadedFileNames = new ArrayList<String>();
        this.selectedUploadedFileNames = new HashSet<String>();
        for (Media media : medias) {
            File uploadedFile = MediaUtil.copyToTempFile(media);
            this.uploadedFiles.add(uploadedFile);
            this.uploadedFileNames.add(this.normalizeFilename(media.getName()));
        }
        this.updateForm(binder);
        this.notifyChange("uploadedFileName", "uploadedFileNames", "multipleFilesUploaded", "selectedUploadedFileName");
    }

    @Command
    public void typeChanged(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.updateForm(binder);
    }

    @Command
    public void downloadExampleFile(@BindingParam(value="fileType") String fileType) throws IOException {
        switch (SurveyFile.SurveyFileType.valueOf((String)fileType)) {
            case COLLECT_EARTH_GRID: {
                File templateFile = new CollectEarthGridTemplateGenerator().generateTemplateCSVFile(this.survey);
                String fileName = String.format("%s_grid_template_%s.csv", this.survey.getName(), Dates.formatDateTime((Date)new Date()));
                Filedownload.save((InputStream)new FileInputStream(templateFile), (String)"text/csv", (String)fileName);
                break;
            }
        }
    }

    @Command
    public void downloadUploadedFile() throws IOException {
        if (this.uploadedFiles != null && this.uploadedFiles.size() == 1) {
            String fileName = this.uploadedFileNames.get(0);
            String contentType = URLConnection.guessContentTypeFromName(fileName);
            Filedownload.save((InputStream)new FileInputStream(this.uploadedFiles.get(0)), (String)contentType, (String)fileName);
        }
    }

    @Command
    public void uploadedFileNamesSelected(@BindingParam(value="filenames") Set<Listitem> filenameItems) {
        HashSet<String> fileNames = new HashSet<String>();
        for (Listitem listitem : filenameItems) {
            fileNames.add((String)listitem.getValue());
        }
        this.selectedUploadedFileNames = fileNames;
        this.notifyChange("selectedUploadedFileNames");
    }

    @Command
    public void deleteUploadedFile(@BindingParam(value="filename") String filename) {
        this._deleteSelectedUploadedFilename(filename);
        this.selectedUploadedFileNames.remove(filename);
        this.notifyChange("uploadedFiles", "uploadedFileNames", "selectedUploadedFileNames");
    }

    @Command
    public void deleteSelectedUploadedFiles() {
        for (String selectedUploadedFileName : this.selectedUploadedFileNames) {
            this._deleteSelectedUploadedFilename(selectedUploadedFileName);
        }
        this.selectedUploadedFileNames = null;
        this.notifyChange("uploadedFiles", "uploadedFileNames", "selectedUploadedFileNames");
    }

    private void _deleteSelectedUploadedFilename(String selectedUploadedFileName) {
        int index = this.uploadedFileNames.indexOf(selectedUploadedFileName);
        this.uploadedFiles.remove(index);
        this.uploadedFileNames.remove(index);
    }

    @Command
    public void downloadFile() {
        byte[] content = this.surveyManager.loadSurveyFileContent((SurveyFile)this.editedItem);
        String fileName = ((SurveyFile)this.editedItem).getFilename();
        String contentType = URLConnection.guessContentTypeFromName(fileName);
        Filedownload.save((byte[])content, (String)contentType, (String)fileName);
    }

    private void updateForm(Binder binder) {
        String filename = null;
        if (this.isMultipleFilesUploaded()) {
            filename = this.getUploadedFileName();
        } else {
            String typeName = (String)this.getFormFieldValue(binder, "type");
            SurveyFile.SurveyFileType type = SurveyFile.SurveyFileType.valueOf((String)typeName);
            filename = type.getFixedFilename();
            if (filename == null) {
                filename = CollectionUtils.isNotEmpty(this.uploadedFiles) ? this.getUploadedFileName() : (String)this.getFormFieldValue(binder, "filenames");
            }
        }
        this.setFormFieldValue(binder, "filenames", (Object)filename);
        this.dispatchApplyChangesCommand(binder);
    }

    private String normalizeFilename(String filename) {
        return filename.replaceAll("[^\\w-.]", "_");
    }

    public String getEditedItemFilename() {
        return this.editedItem == null ? null : ((SurveyFile)this.editedItem).getFilename();
    }

    public String getUploadedFileName() {
        return this.uploadedFileNames == null ? null : StringUtils.join(this.uploadedFileNames, (String)"\n");
    }

    public List<String> getUploadedFileNames() {
        return this.uploadedFileNames;
    }

    public Set<String> getSelectedUploadedFileNames() {
        return this.selectedUploadedFileNames;
    }

    public boolean isMultipleFilesUploaded() {
        return this.uploadedFiles != null && this.uploadedFiles.size() > 1;
    }

    public Map<String, String> getForm() {
        return this.form;
    }

    public void setForm(Map<String, String> form) {
        this.form = form;
    }

    public SurveyManager getSurveyManager() {
        return this.surveyManager;
    }
}

