/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.validator;

import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.web.controller.SurveyController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class SurveyCloneParametersValidator
extends SimpleValidator<SurveyController.SurveyCloneParameters> {
    private static final String NAME_ALREADY_IN_USE_MESSAGE_KEY = "survey.validation.nameAlreadyInUse";
    private static final String NEW_SURVEY_NAME_FIELD = "newSurveyName";
    private static final String ORIGINAL_SURVEY_NAME_FIELD = "originalSurveyName";
    private static final String ORIGINAL_SURVEY_NOT_FOUND_MESSAGE_KEY = "survey.clone.validation.originalSurveyNotFound";
    @Autowired
    private SurveyManager surveyManager;

    @Override
    public void validateForm(SurveyController.SurveyCloneParameters parameters, Errors errors) {
        if (this.validateRequiredField(errors, ORIGINAL_SURVEY_NAME_FIELD)) {
            this.validateOriginalSurveyExists(parameters, errors);
        }
        if (this.validateRequiredField(errors, NEW_SURVEY_NAME_FIELD) && this.validateInternalName(errors, NEW_SURVEY_NAME_FIELD) && this.validateMinLength(errors, NEW_SURVEY_NAME_FIELD, 5)) {
            this.validateSurveyNameUniqueness(parameters, errors);
        }
        this.validateRequiredFields(errors, "originalSurveyType");
    }

    private void validateOriginalSurveyExists(SurveyController.SurveyCloneParameters parameters, Errors errors) {
        SimpleValidator.ErrorsHelper helper = new SimpleValidator.ErrorsHelper(errors);
        String originalSurveyName = helper.getStringValue(ORIGINAL_SURVEY_NAME_FIELD);
        SurveySummary summary = this.surveyManager.loadSummaryByName(originalSurveyName);
        if (summary == null) {
            errors.rejectValue(ORIGINAL_SURVEY_NAME_FIELD, ORIGINAL_SURVEY_NOT_FOUND_MESSAGE_KEY, (Object[])new String[]{originalSurveyName}, null);
        }
    }

    private boolean validateSurveyNameUniqueness(SurveyController.SurveyCloneParameters params, Errors errors) {
        SurveySummary existingSummary = this.surveyManager.loadSummaryByName(params.getNewSurveyName());
        if (existingSummary != null) {
            errors.rejectValue(NEW_SURVEY_NAME_FIELD, NAME_ALREADY_IN_USE_MESSAGE_KEY);
            return false;
        }
        return true;
    }
}

