/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.form.validation;

import java.util.List;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.form.DataQueryForm;
import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.datacleansing.manager.DataQueryManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.NodeDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class DataQueryValidator
extends SimpleValidator<DataQueryForm> {
    private static final String TITLE_FIELD = "title";
    private static final String ENTITY_DEFINITION_ID_FIELD = "entityDefinitionId";
    private static final String ATTRIBUTE_DEFINITION_ID_FIELD = "attributeDefinitionId";
    private static final String CONDITIONS_FIELD = "conditions";
    @Autowired
    private DataQueryManager dataQueryManager;

    @Override
    public void validateForm(DataQueryForm target, Errors errors) {
        this.validateRequiredField(errors, TITLE_FIELD);
        if (this.validateRequiredFields(errors, ENTITY_DEFINITION_ID_FIELD, ATTRIBUTE_DEFINITION_ID_FIELD, CONDITIONS_FIELD) && this.validateConditions(target, errors)) {
            this.validateUniqueness(target, errors);
        }
    }

    private boolean validateConditions(DataQueryForm target, Errors errors) {
        CollectSurvey survey = this.sessionManager.getActiveSurvey();
        NodeDefinition contextNodeDef = survey.getSchema().getDefinitionById(target.getEntityDefinitionId().intValue());
        NodeDefinition thisNodeDef = survey.getSchema().getDefinitionById(target.getAttributeDefinitionId().intValue());
        String expression = target.getConditions();
        boolean valid = this.validateBooleanExpression(errors, contextNodeDef, thisNodeDef, CONDITIONS_FIELD, expression);
        return valid;
    }

    private boolean validateUniqueness(DataQueryForm target, Errors errors) {
        CollectSurvey survey = this.sessionManager.getActiveSurvey();
        List queries = this.dataQueryManager.loadBySurvey(survey);
        for (DataQuery dataQuery : queries) {
            if (((Integer)dataQuery.getId()).equals(target.getId())) continue;
            boolean valid = true;
            if (dataQuery.getTitle().equalsIgnoreCase(target.getTitle())) {
                this.rejectDuplicateValue(errors, TITLE_FIELD, new Object[0]);
                valid = false;
            } else if (Integer.valueOf(dataQuery.getEntityDefinitionId()).equals(target.getEntityDefinitionId()) && Integer.valueOf(dataQuery.getAttributeDefinitionId()).equals(target.getAttributeDefinitionId()) && dataQuery.getConditions().equals(target.getConditions())) {
                this.rejectDuplicateValue(errors, ENTITY_DEFINITION_ID_FIELD, new Object[0]);
                this.rejectDuplicateValue(errors, ATTRIBUTE_DEFINITION_ID_FIELD, new Object[0]);
                this.rejectDuplicateValue(errors, CONDITIONS_FIELD, new Object[0]);
                valid = false;
            }
            if (valid) continue;
            return false;
        }
        return true;
    }
}

