/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.codelist;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FilenameUtils;
import org.openforis.collect.io.metadata.codelist.CodeListImportTask;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.CodeList;

public class CodeListBatchImportJob
extends Job {
    private static final String ZIP = "zip";
    private static final String CSV = "csv";
    private CodeListManager codeListManager;
    private CollectSurvey survey;
    private File file;
    private boolean overwriteData;
    private ZipFile zipFile;
    private Enumeration<ZipArchiveEntry> zipEntries;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.zipFile = new ZipFile(this.file);
        this.zipEntries = this.zipFile.getEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateInput() throws Throwable {
        super.validateInput();
        if (!this.validateExtension(this.file.getName(), ZIP)) {
            throw new IllegalArgumentException("survey.code_list.import_data.error.invalid_extension");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.file);
            Enumeration entries = zipFile.getEntries();
            if (!entries.hasMoreElements()) {
                throw new IllegalArgumentException("survey.code_list.import_data.error.empty_file");
            }
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String entryName = entry.getName();
                if (!this.validateExtension(entryName, CSV)) {
                    throw new IllegalArgumentException("survey.code_list.import_data.error.invalid_extension");
                }
                if (FilenameUtils.getBaseName((String)entryName).matches("[a-z][a-z0-9_]*")) continue;
                throw new IllegalArgumentException("survey.code_list.import_data.error.invalid_filename");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipFile);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)zipFile);
    }

    private boolean validateExtension(String fileName, String expectedExtension) {
        return expectedExtension.equals(FilenameUtils.getExtension((String)fileName));
    }

    protected void buildTasks() throws Throwable {
        Enumeration entries = this.zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            String entryName = entry.getName();
            if (!CSV.equalsIgnoreCase(FilenameUtils.getExtension((String)entryName))) continue;
            this.addCodeListImportTask(FilenameUtils.getBaseName((String)entryName));
        }
    }

    protected void initializeTask(Worker task) {
        try {
            ZipArchiveEntry entry = this.zipEntries.nextElement();
            InputStream is = this.zipFile.getInputStream(entry);
            ((CodeListImportTask)task).setInputStream(is);
            ((CodeListImportTask)task).setEntryName(entry.getName());
            super.initializeTask(task);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addCodeListImportTask(String codeListName) {
        CodeList codeList = this.getOrCreateCodeList(codeListName);
        CodeListImportTask task = new CodeListImportTask();
        task.setCodeListManager(this.codeListManager);
        task.setCodeList(codeList);
        task.setOverwriteData(this.overwriteData);
        this.addTask((Worker)task);
    }

    private CodeList getOrCreateCodeList(String codeListName) {
        CodeList codeList = this.survey.getCodeList(codeListName);
        if (codeList == null) {
            codeList = this.survey.createCodeList();
            codeList.setName(codeListName);
            this.survey.addCodeList(codeList);
        }
        return codeList;
    }

    public void setCodeListManager(CodeListManager codeListManager) {
        this.codeListManager = codeListManager;
    }

    public void setSurvey(CollectSurvey survey) {
        this.survey = survey;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setOverwriteData(boolean overwriteData) {
        this.overwriteData = overwriteData;
    }
}

