/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SpeciesManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.TaxonSearchParameters;
import org.openforis.collect.manager.dataexport.species.SpeciesExportProcess;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.CollectTaxonomy;
import org.openforis.collect.model.proxy.TaxonOccurrenceProxy;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.utils.Proxies;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SpeciesController {
    private static final String SPECIES_LIST_CSV_FILE_NAME = "species_list.csv";
    @Autowired
    private SpeciesManager speciesManager;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    @Qualifier(value="sessionManager")
    private SessionManager sessionManager;

    @RequestMapping(value={"api/survey/{surveyId}/taxonomy/{taxonomyId}/export.csv"}, method={RequestMethod.GET})
    @ResponseBody
    public String exportSpecies(HttpServletResponse response, @PathVariable(value="surveyId") Integer surveyId, @PathVariable(value="taxonomyId") Integer taxonomyId) throws IOException {
        Controllers.setOutputContent(response, SPECIES_LIST_CSV_FILE_NAME, "text/csv");
        ServletOutputStream out = response.getOutputStream();
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId.intValue());
        SpeciesExportProcess process = new SpeciesExportProcess(this.speciesManager);
        process.exportToCSV((OutputStream)out, survey, taxonomyId);
        return "ok";
    }

    @Secured(value={"ROLE_ENTRY"})
    @RequestMapping(value={"api/survey/{surveyId}/taxonomy/{taxonomyName}/query"}, method={RequestMethod.POST})
    @ResponseBody
    public List<TaxonOccurrenceProxy> findTaxon(@PathVariable(value="surveyId") int surveyId, @PathVariable(value="taxonomyName") String taxonomyName, @RequestBody TaxonQuery query) {
        List list;
        CollectTaxonomy taxonomy = this.loadTaxonomy(surveyId, taxonomyName);
        switch (query.field) {
            case FAMILY_CODE: {
                list = this.speciesManager.findByFamilyCode(taxonomy, query.searchString, query.maxResults, query.parameters);
                break;
            }
            case FAMILY_SCIENTIFIC_NAME: {
                list = this.speciesManager.findByFamilyScientificName(taxonomy, query.searchString, query.maxResults, query.parameters);
                break;
            }
            case CODE: {
                list = this.speciesManager.findByCode(taxonomy, query.searchString, query.maxResults, query.parameters);
                break;
            }
            case SCIENTIFIC_NAME: {
                list = this.speciesManager.findByScientificName(taxonomy, query.searchString, query.maxResults, query.parameters);
                break;
            }
            case VERNACULAR_NAME: {
                list = this.speciesManager.findByVernacularName(taxonomy, null, query.searchString, query.maxResults, query.parameters);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Taxon query: invalid field %s", new Object[]{query.field}));
            }
        }
        return Proxies.fromList(list, TaxonOccurrenceProxy.class);
    }

    private CollectTaxonomy loadTaxonomy(int surveyId, String taxonomyName) {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        return this.speciesManager.loadTaxonomyByName(survey, taxonomyName);
    }

    public static class TaxonQuery {
        public FIELD field;
        public String searchString;
        public int maxResults = 30;
        public TaxonSearchParameters parameters;

        public static enum FIELD {
            FAMILY_CODE,
            FAMILY_SCIENTIFIC_NAME,
            CODE,
            SCIENTIFIC_NAME,
            VERNACULAR_NAME;

        }
    }
}

