/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import java.util.List;
import org.openforis.collect.designer.form.VersionableItemFormObject;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListLabel;

public class CodeListFormObject
extends VersionableItemFormObject<CodeList> {
    private String name;
    private String itemLabel;
    private String listLabel;
    private String description;
    private String type = Type.FLAT.name();
    private String defaultItemLabel;
    private String defaultListLabel;
    private String defaultDescription;

    @Override
    public void loadFrom(CodeList source, String languageCode) {
        super.loadFrom(source, languageCode);
        this.name = source.getName();
        this.itemLabel = source.getLabel(CodeListLabel.Type.ITEM, languageCode);
        this.listLabel = source.getLabel(CodeListLabel.Type.LIST, languageCode);
        this.description = source.getDescription(languageCode);
        this.defaultItemLabel = source.getLabel(CodeListLabel.Type.ITEM);
        this.defaultListLabel = source.getLabel(CodeListLabel.Type.LIST);
        this.defaultDescription = source.getDescription();
        List levels = source.getHierarchy();
        boolean hasMultipleLevels = levels.size() > 1;
        this.type = hasMultipleLevels ? Type.HIERARCHICAL.name() : Type.FLAT.name();
    }

    @Override
    public void saveTo(CodeList dest, String languageCode) {
        super.saveTo(dest, languageCode);
        dest.setName(this.name);
        dest.setLabel(CodeListLabel.Type.ITEM, languageCode, this.itemLabel);
        dest.setLabel(CodeListLabel.Type.LIST, languageCode, this.listLabel);
        dest.setDescription(languageCode, this.description);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getItemLabel() {
        return this.itemLabel;
    }

    public void setItemLabel(String itemLabel) {
        this.itemLabel = itemLabel;
    }

    public String getListLabel() {
        return this.listLabel;
    }

    public void setListLabel(String listLabel) {
        this.listLabel = listLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDefaultItemLabel() {
        return this.defaultItemLabel;
    }

    public String getDefaultListLabel() {
        return this.defaultListLabel;
    }

    public String getDefaultDescription() {
        return this.defaultDescription;
    }

    public static enum Type {
        FLAT,
        HIERARCHICAL;

    }
}

