/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.AttributeDefinitionFormObject;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;

public class CoordinateAttributeDefinitionFormObject<T extends CoordinateAttributeDefinition>
extends AttributeDefinitionFormObject<T> {
    private String fieldsOrderValue;
    private String xFieldLabel;
    private String yFieldLabel;
    private String srsFieldLabel;
    private boolean allowOnlyDeviceCoordinate;
    private boolean showSrsField;
    private boolean includeAltitude;
    private boolean includeAccuracy;

    CoordinateAttributeDefinitionFormObject(EntityDefinition parentDefn) {
        super(parentDefn);
    }

    @Override
    public void saveTo(T dest, String languageCode) {
        super.saveTo(dest, languageCode);
        this.saveFieldOrderValue(dest);
        dest.setFieldLabel("x", languageCode, this.xFieldLabel);
        dest.setFieldLabel("y", languageCode, this.yFieldLabel);
        dest.setFieldLabel("srs", languageCode, this.srsFieldLabel);
        CollectAnnotations annotations = ((CollectSurvey)dest.getSurvey()).getAnnotations();
        annotations.setAllowOnlyDeviceCoordinate(dest, this.allowOnlyDeviceCoordinate);
        annotations.setShowSrsField(dest, this.showSrsField);
        annotations.setIncludeCoordinateAltitude(dest, this.includeAltitude);
        annotations.setIncludeCoordinateAccuracy(dest, this.includeAccuracy);
    }

    protected void saveFieldOrderValue(T dest) {
        CollectSurvey survey = (CollectSurvey)dest.getSurvey();
        UIOptions uiOptions = survey.getUIOptions();
        UIOptions.CoordinateAttributeFieldsOrder fieldsOrder = StringUtils.isBlank((CharSequence)this.fieldsOrderValue) ? null : UIOptions.CoordinateAttributeFieldsOrder.valueOf((String)this.fieldsOrderValue);
        uiOptions.setFieldsOrder(dest, fieldsOrder);
    }

    @Override
    public void loadFrom(T source, String languageCode) {
        super.loadFrom(source, languageCode);
        this.loadFieldsOrderValue(source);
        this.xFieldLabel = source.getFieldLabel("x", languageCode);
        this.yFieldLabel = source.getFieldLabel("y", languageCode);
        this.srsFieldLabel = source.getFieldLabel("srs", languageCode);
        CollectAnnotations annotations = ((CollectSurvey)source.getSurvey()).getAnnotations();
        this.allowOnlyDeviceCoordinate = annotations.isAllowOnlyDeviceCoordinate(source);
        this.showSrsField = annotations.isShowSrsField(source);
        this.includeAltitude = annotations.isIncludeCoordinateAltitude(source);
        this.includeAccuracy = annotations.isIncludeCoordinateAccuracy(source);
    }

    protected void loadFieldsOrderValue(T source) {
        CollectSurvey survey = (CollectSurvey)source.getSurvey();
        UIOptions uiOptions = survey.getUIOptions();
        UIOptions.CoordinateAttributeFieldsOrder fieldsOrder = uiOptions.getFieldsOrder(source);
        this.fieldsOrderValue = fieldsOrder.name();
    }

    public String getFieldsOrderValue() {
        return this.fieldsOrderValue;
    }

    public void setFieldsOrderValue(String fieldsOrderValue) {
        this.fieldsOrderValue = fieldsOrderValue;
    }

    public String getxFieldLabel() {
        return this.xFieldLabel;
    }

    public void setxFieldLabel(String xFieldLabel) {
        this.xFieldLabel = xFieldLabel;
    }

    public String getyFieldLabel() {
        return this.yFieldLabel;
    }

    public void setyFieldLabel(String yFieldLabel) {
        this.yFieldLabel = yFieldLabel;
    }

    public String getSrsFieldLabel() {
        return this.srsFieldLabel;
    }

    public void setSrsFieldLabel(String srsFieldLabel) {
        this.srsFieldLabel = srsFieldLabel;
    }

    public boolean isAllowOnlyDeviceCoordinate() {
        return this.allowOnlyDeviceCoordinate;
    }

    public void setAllowOnlyDeviceCoordinate(boolean allowOnlyDeviceCoordinate) {
        this.allowOnlyDeviceCoordinate = allowOnlyDeviceCoordinate;
    }

    public boolean isShowSrsField() {
        return this.showSrsField;
    }

    public void setShowSrsField(boolean showSrsField) {
        this.showSrsField = showSrsField;
    }

    public boolean isIncludeAltitude() {
        return this.includeAltitude;
    }

    public void setIncludeAltitude(boolean includeAltitude) {
        this.includeAltitude = includeAltitude;
    }

    public boolean isIncludeAccuracy() {
        return this.includeAccuracy;
    }

    public void setIncludeAccuracy(boolean includeAccuracy) {
        this.includeAccuracy = includeAccuracy;
    }
}

