/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager.codelistimport;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.io.exception.ParsingException;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.openforis.collect.io.parsing.CSVFileOptions;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.codelistimport.CodeListCSVReader;
import org.openforis.collect.manager.codelistimport.CodeListImportStatus;
import org.openforis.collect.manager.codelistimport.CodeListLine;
import org.openforis.collect.manager.process.AbstractProcess;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListLevel;
import org.openforis.idm.metamodel.LanguageSpecificText;

public class CodeListImportProcess
extends AbstractProcess<Void, CodeListImportStatus> {
    private static final Logger LOG = LogManager.getLogger(CodeListImportProcess.class);
    private static final String IMPORTING_FILE_ERROR_MESSAGE_KEY = "codeListImport.error.internalErrorImportingFile";
    private static final String DIFFERENT_LABEL_MESSAGE_KEY = "codeListImport.parsingError.differentLabel";
    private CodeListManager codeListManager;
    private File file;
    private CSVFileOptions csvFileOptions;
    private CodeList codeList;
    private CodeListCSVReader reader;
    private List<String> levels;
    private Map<String, CodeListItem> codeToRootItem;
    private boolean overwriteData;

    public CodeListImportProcess(CodeListManager codeListManager, CodeList codeList, String langCode, File file, boolean overwriteData) {
        this(codeListManager, codeList, langCode, file, new CSVFileOptions(), overwriteData);
    }

    public CodeListImportProcess(CodeListManager codeListManager, CodeList codeList, String langCode, File file, CSVFileOptions csvFileOptions, boolean overwriteData) {
        this.codeListManager = codeListManager;
        this.codeList = codeList;
        this.file = file;
        this.csvFileOptions = csvFileOptions;
        this.overwriteData = overwriteData;
    }

    public void init() {
        super.init();
        this.validateParameters();
        this.codeToRootItem = new LinkedHashMap<String, CodeListItem>();
    }

    protected void validateParameters() {
        if (!this.file.exists() && !this.file.canRead()) {
            ((CodeListImportStatus)this.status).error();
            ((CodeListImportStatus)this.status).setErrorMessage(IMPORTING_FILE_ERROR_MESSAGE_KEY);
        }
    }

    protected void initStatus() {
        this.status = new CodeListImportStatus();
    }

    public void startProcessing() throws Exception {
        super.startProcessing();
        this.processFile();
    }

    protected void processFile() throws IOException {
        this.parseCSVLines();
        if (((CodeListImportStatus)this.status).hasErrors()) {
            ((CodeListImportStatus)this.status).error();
        }
        if (((CodeListImportStatus)this.status).isRunning()) {
            this.saveData();
            ((CodeListImportStatus)this.status).complete();
        }
    }

    protected void saveData() {
        if (this.overwriteData) {
            this.codeList.removeAllLevels();
        }
        this.addLevelsToCodeList();
        this.codeListManager.deleteAllItems(this.codeList);
        ArrayList<CodeListItem> rootItems = new ArrayList<CodeListItem>(this.codeToRootItem.values());
        this.codeListManager.saveItemsAndDescendants(rootItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCSVLines() {
        long currentRowNumber = 0L;
        try {
            CollectSurvey survey = (CollectSurvey)this.codeList.getSurvey();
            List languages = survey.getLanguages();
            String defaultLanguage = survey.getDefaultLanguage();
            this.reader = new CodeListCSVReader(this.file, this.csvFileOptions, languages, defaultLanguage);
            this.reader.init();
            this.levels = this.reader.getLevels();
            ((CodeListImportStatus)this.status).addProcessedRow(1L);
            currentRowNumber = 2L;
            while (((CodeListImportStatus)this.status).isRunning()) {
                try {
                    CodeListLine line = (CodeListLine)this.reader.readNextLine();
                    if (line != null) {
                        CodeListItem currentParentItem = null;
                        List<String> levelCodes = line.getLevelCodes();
                        for (int levelIdx = 0; levelIdx < levelCodes.size(); ++levelIdx) {
                            CodeListItem item;
                            boolean lastLevel = levelIdx == levelCodes.size() - 1;
                            currentParentItem = item = this.processLevel(currentParentItem, line, levelIdx, lastLevel);
                        }
                        ((CodeListImportStatus)this.status).addProcessedRow(currentRowNumber);
                    }
                    if (this.reader.isReady()) continue;
                    break;
                }
                catch (ParsingException e) {
                    ((CodeListImportStatus)this.status).addParsingError(currentRowNumber, e.getError());
                }
                finally {
                    ++currentRowNumber;
                }
            }
            ((CodeListImportStatus)this.status).setTotal(this.reader.getLinesRead() + 1L);
        }
        catch (ParsingException e) {
            ((CodeListImportStatus)this.status).error();
            ((CodeListImportStatus)this.status).addParsingError(1L, e.getError());
        }
        catch (Exception e) {
            ((CodeListImportStatus)this.status).error();
            ((CodeListImportStatus)this.status).addParsingError(currentRowNumber, new ParsingError(ParsingError.ErrorType.IOERROR, e.toString()));
            LOG.error("Error importing code list CSV file", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Object)this.reader));
        }
    }

    protected CodeListItem processLevel(CodeListItem parent, CodeListLine line, int levelIdx, boolean lastLevel) {
        List<LanguageSpecificText> labels;
        List<String> codes = line.getLevelCodes();
        if (codes.isEmpty()) {
            this.addEmptyCodeColumnError(line, levelIdx);
        }
        String code = codes.get(levelIdx);
        if (lastLevel && this.isDuplicate(code, parent)) {
            this.addDuplicateCodeError(line, levelIdx);
        }
        if (CollectionUtils.isEmpty(labels = line.getLabelItems(levelIdx))) {
            this.addMissingDefaultLanguageLabelError(line, levelIdx);
        } else {
            for (LanguageSpecificText label : labels) {
                if (!this.hasDifferentLabel(code, label, parent)) continue;
                this.addDifferentLabelError(line, levelIdx, label.getLanguage());
            }
        }
        CodeListItem result = this.getChildItem(parent, code);
        if (result == null) {
            result = this.codeList.createItem(levelIdx + 1);
            List<LanguageSpecificText> descriptions = line.getDescriptionItems(levelIdx);
            this.fillItem(result, code, labels, descriptions);
            if (parent == null) {
                this.codeToRootItem.put(code, result);
            } else {
                parent.addChildItem(result);
            }
        }
        return result;
    }

    protected boolean isDuplicate(String code, CodeListItem parentItem) {
        CodeListItem duplicateItem = this.getChildItem(parentItem, code);
        return duplicateItem != null;
    }

    protected boolean hasDifferentLabel(String code, LanguageSpecificText item, CodeListItem parentItem) {
        CodeListItem existingItem = this.getChildItem(parentItem, code);
        if (existingItem == null) {
            return false;
        }
        String lang = item.getLanguage();
        String label = item.getText();
        String existingItemLabel = existingItem.getLabel(lang);
        return !existingItemLabel.equals(label);
    }

    protected CodeListItem getChildItem(CodeListItem parentItem, String code) {
        CodeListItem duplicateItem = parentItem == null ? this.codeToRootItem.get(code) : parentItem.getChildItem(code);
        return duplicateItem;
    }

    protected void addEmptyCodeColumnError(CodeListLine line, int levelIdx) {
        String level = this.levels.get(levelIdx);
        String column = level + "_code";
        long lineNumber = line.getLineNumber();
        ParsingError error = new ParsingError(ParsingError.ErrorType.EMPTY, lineNumber, column);
        ((CodeListImportStatus)this.status).addParsingError(lineNumber, error);
    }

    protected void addDuplicateCodeError(CodeListLine line, int levelIdx) {
        String level = this.levels.get(levelIdx);
        String column = level + "_code";
        long lineNumber = line.getLineNumber();
        ParsingError error = new ParsingError(ParsingError.ErrorType.DUPLICATE_VALUE, lineNumber, column);
        ((CodeListImportStatus)this.status).addParsingError(lineNumber, error);
    }

    protected void addDifferentLabelError(CodeListLine line, int levelIdx, String lang) {
        String level = this.levels.get(levelIdx);
        String column = level + "_label" + "_" + lang;
        long lineNumber = line.getLineNumber();
        ParsingError error = new ParsingError(ParsingError.ErrorType.INVALID_VALUE, lineNumber, column, DIFFERENT_LABEL_MESSAGE_KEY);
        ((CodeListImportStatus)this.status).addParsingError(lineNumber, error);
    }

    protected void addMissingDefaultLanguageLabelError(CodeListLine line, int levelIdx) {
        String level = this.levels.get(levelIdx);
        String column = level + "_label";
        long lineNumber = line.getLineNumber();
        ParsingError error = new ParsingError(ParsingError.ErrorType.EMPTY, lineNumber, column);
        ((CodeListImportStatus)this.status).addParsingError(lineNumber, error);
    }

    protected CodeListItem getCodeListItemInDescendants(String code) {
        LinkedList<CodeListItem> stack = new LinkedList<CodeListItem>();
        stack.addAll(this.codeToRootItem.values());
        while (!stack.isEmpty()) {
            CodeListItem item = (CodeListItem)stack.pop();
            if (item.matchCode(code)) {
                return item;
            }
            stack.addAll(item.getChildItems());
        }
        return null;
    }

    protected void fillItem(CodeListItem item, String code, List<LanguageSpecificText> labelItems, List<LanguageSpecificText> descriptionItems) {
        item.setCode(code);
        for (LanguageSpecificText textItem : labelItems) {
            item.setLabel(textItem.getLanguage(), textItem.getText());
        }
        for (LanguageSpecificText textItem : descriptionItems) {
            item.setDescription(textItem.getLanguage(), textItem.getText());
        }
    }

    protected void addLevelsToCodeList() {
        if (this.levels != null && this.levels.size() > 1) {
            for (String levelName : this.levels) {
                CodeListLevel level = new CodeListLevel();
                level.setName(levelName);
                this.codeList.addLevel(level);
            }
        }
    }
}

