/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openforis.collect.ProxyContext;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.proxy.NodeProxy;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.VersionableSurveyObject;
import org.openforis.idm.metamodel.validation.ValidationResultFlag;
import org.openforis.idm.model.Entity;
import org.openforis.idm.model.Node;
import org.openforis.idm.model.Record;

public class EntityProxy
extends NodeProxy {
    private transient Entity entity;
    private transient List<NodeDefinition> availableChildDefinitions;

    public EntityProxy(EntityProxy parent, Entity entity, ProxyContext context) {
        super(parent, (Node<?>)entity, context);
        this.entity = entity;
        this.availableChildDefinitions = this.getAvailableChildDefinitions();
    }

    public Map<Integer, List<NodeProxy>> getChildrenByDefinitionId() {
        HashMap<Integer, List<NodeProxy>> result = new HashMap<Integer, List<NodeProxy>>();
        for (NodeDefinition childDefinition : this.availableChildDefinitions) {
            List nodes = this.entity.getChildren(childDefinition);
            List<NodeProxy> proxies = NodeProxy.fromList(this, nodes, this.context);
            result.put(childDefinition.getId(), proxies);
        }
        return result;
    }

    public Map<Integer, Boolean> getChildrenRelevanceByDefinitionId() {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>(this.availableChildDefinitions.size());
        for (NodeDefinition childDefinition : this.availableChildDefinitions) {
            map.put(childDefinition.getId(), this.entity.isRelevant(childDefinition));
        }
        return map;
    }

    public Map<Integer, ValidationResultFlag> getChildrenMinCountValidationByDefinitionId() {
        HashMap<Integer, ValidationResultFlag> map = new HashMap<Integer, ValidationResultFlag>(this.availableChildDefinitions.size());
        for (NodeDefinition childDefinition : this.availableChildDefinitions) {
            map.put(childDefinition.getId(), this.entity.getMinCountValidationResult(childDefinition));
        }
        return map;
    }

    public Map<Integer, ValidationResultFlag> getChildrenMaxCountValidationByDefinitionId() {
        HashMap<Integer, ValidationResultFlag> map = new HashMap<Integer, ValidationResultFlag>(this.availableChildDefinitions.size());
        for (NodeDefinition childDefinition : this.availableChildDefinitions) {
            map.put(childDefinition.getId(), this.entity.getMaxCountValidationResult(childDefinition));
        }
        return map;
    }

    public Map<Integer, Integer> getChildrenMinCountByDefinitionId() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(this.availableChildDefinitions.size());
        for (NodeDefinition childDefinition : this.availableChildDefinitions) {
            map.put(childDefinition.getId(), this.entity.getMinCount(childDefinition));
        }
        return map;
    }

    public Map<Integer, Integer> getChildrenMaxCountByDefinitionId() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(this.availableChildDefinitions.size());
        for (NodeDefinition childDefinition : this.availableChildDefinitions) {
            map.put(childDefinition.getId(), this.entity.getMaxCount(childDefinition));
        }
        return map;
    }

    public Map<Integer, Boolean> getChildrenErrorVisibleByDefinitionId() {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>(this.availableChildDefinitions.size());
        for (NodeDefinition childDefinition : this.availableChildDefinitions) {
            map.put(childDefinition.getId(), Boolean.FALSE);
        }
        return map;
    }

    private List<NodeDefinition> getAvailableChildDefinitions() {
        ArrayList<NodeDefinition> result = new ArrayList<NodeDefinition>();
        UIOptions uiOptions = ((CollectSurvey)this.entity.getSurvey()).getUIOptions();
        for (NodeDefinition childDefinition : this.getChildDefinitions()) {
            if (!this.isApplicable(childDefinition) || uiOptions.isHidden(childDefinition)) continue;
            result.add(childDefinition);
        }
        return result;
    }

    protected boolean isApplicable(NodeDefinition childDefinition) {
        Record record = this.entity.getRecord();
        ModelVersion version = record.getVersion();
        return version == null || version.isApplicable((VersionableSurveyObject)childDefinition);
    }

    public boolean isEnumerated() {
        EntityDefinition definition = (EntityDefinition)this.entity.getDefinition();
        return definition.isEnumerable() && definition.isEnumerate();
    }

    private List<NodeDefinition> getChildDefinitions() {
        EntityDefinition definition = (EntityDefinition)this.entity.getDefinition();
        return definition.getChildDefinitions();
    }
}

