/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.manager.ItemManager;
import org.openforis.collect.model.User;
import org.openforis.collect.web.controller.BasicController;
import org.openforis.commons.web.AbstractFormUpdateValidationResponse;
import org.openforis.commons.web.PersistedObjectForm;
import org.openforis.commons.web.Response;
import org.openforis.idm.metamodel.PersistedObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public abstract class AbstractPersistedObjectEditFormController<I extends Number, T extends PersistedObject<I>, F extends PersistedObjectForm<I, T>, M extends ItemManager<T, I>>
extends BasicController {
    private static final String[] IGNORE_FIELDS = new String[]{"creationDate", "modifiedDate", "uuid"};
    protected M itemManager;

    protected abstract T createItemInstance();

    protected abstract F createFormInstance(T var1);

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<F> loadAll() {
        List<T> items = this.loadAllItems();
        return this.createFormInstances(items);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public F load(@PathVariable I id) {
        T item = this.loadItem(id);
        F form = this.createFormInstance(item);
        return form;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Response insert(@Validated F form, BindingResult result) {
        return this.save(form, result);
    }

    @RequestMapping(method={RequestMethod.PATCH})
    @ResponseBody
    public Response update(@Validated F form, BindingResult result) {
        return this.save(form, result);
    }

    protected Response save(@Validated F form, BindingResult result) {
        SimpleFormUpdateResponse response;
        List errors = result.getAllErrors();
        if (errors.isEmpty()) {
            T item = this.loadOrCreateItem(form);
            this.copyFormIntoItem(form, item);
            this.itemManager.save(item, this.getLoggedUser());
            F responseForm = this.createFormInstance(item);
            response = new SimpleFormUpdateResponse(this, responseForm);
        } else {
            response = new SimpleFormUpdateResponse(this, errors);
        }
        return response;
    }

    @RequestMapping(value={"/{id}/duplicate"}, method={RequestMethod.POST})
    @ResponseBody
    public Response duplicate(@RequestParam I itemId, BindingResult result) {
        PersistedObject item;
        PersistedObject newItem = item = this.itemManager.loadById(itemId);
        newItem.setId(null);
        this.itemManager.save(newItem, this.getLoggedUser());
        F responseForm = this.createFormInstance(newItem);
        return new SimpleFormUpdateResponse(this, responseForm);
    }

    @RequestMapping(value={"validate"}, method={RequestMethod.POST})
    @ResponseBody
    public Response validate(@Validated F form, BindingResult result) {
        List errors = result.getAllErrors();
        SimpleFormUpdateResponse response = new SimpleFormUpdateResponse(this, errors);
        return response;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Response delete(@PathVariable I id) {
        try {
            T item = this.loadItem(id);
            this.itemManager.delete(item);
            return new Response();
        }
        catch (Exception e) {
            return this.createErrorResponse(e);
        }
    }

    protected T loadOrCreateItem(F form) {
        if (form.getId() == null) {
            return this.createItemInstance();
        }
        return this.loadItem(form.getId());
    }

    protected T loadItem(I id) {
        return (T)this.itemManager.loadById(id);
    }

    protected List<T> loadAllItems() {
        return this.itemManager.loadAll();
    }

    protected List<F> createFormInstances(List<T> items) {
        ArrayList<F> forms = new ArrayList<F>(items.size());
        for (PersistedObject item : items) {
            forms.add(this.createFormInstance(item));
        }
        return forms;
    }

    protected void copyFormIntoItem(F form, T item) {
        form.copyTo(item, IGNORE_FIELDS);
    }

    protected Response createErrorResponse(Exception e) {
        Response response = new Response();
        response.setErrorStatus();
        response.setErrorMessage(e.getMessage());
        return response;
    }

    protected User getLoggedUser() {
        return null;
    }

    @Autowired
    public void setItemManager(M itemManager) {
        this.itemManager = itemManager;
    }

    public static class SimpleFormUpdateResponse
    extends AbstractFormUpdateValidationResponse<F> {
        final /* synthetic */ AbstractPersistedObjectEditFormController this$0;

        public SimpleFormUpdateResponse(F form) {
            this.this$0 = this$0;
            super(form);
        }

        public SimpleFormUpdateResponse(AbstractPersistedObjectEditFormController this$0, List<ObjectError> errors) {
            this.this$0 = this$0;
            super(errors);
        }
    }
}

