/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.openforis.collect.designer.form.AttributeFormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.ReferenceDataAttributesEditor;
import org.openforis.collect.designer.viewmodel.SamplingPointDataImportPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.io.metadata.ReferenceDataExportOutputFormat;
import org.openforis.collect.io.metadata.samplingdesign.SamplingDesignExportJob;
import org.openforis.collect.io.metadata.samplingdesign.SamplingDesignFileColumn;
import org.openforis.collect.manager.SamplingDesignManager;
import org.openforis.collect.model.SamplingDesignItem;
import org.openforis.collect.model.SamplingDesignSummaries;
import org.openforis.collect.utils.Dates;
import org.openforis.concurrency.Job;
import org.openforis.idm.metamodel.ReferenceDataSchema;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Window;

public class SamplingPointDataVM
extends SurveyBaseVM {
    public static final String SAMPLING_POINT_DATA_UPDATED_COMMAND = "samplingPointDataUpdated";
    public static final String CLOSE_SAMPLING_POINT_DATA_IMPORT_POPUP_COMMAND = "closeSamplingPointDataImportPopUp";
    private static final int ITEMS_PAGE_SIZE = 20;
    private Window samplingPointDataImportPopUp;
    @WireVariable
    private SamplingDesignManager samplingDesignManager;
    private ReferenceDataAttributesEditor referenceDataAttributesEditor;
    private int itemsPage = 0;
    private SamplingDesignSummaries itemsSummaries;

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
        this.loadItems();
    }

    public List<AttributeFormObject> getAttributes() {
        if (this.referenceDataAttributesEditor == null) {
            this.initReferenceDataAttributesEditor();
        }
        return this.referenceDataAttributesEditor.getAttributes();
    }

    @Command
    @NotifyChange(value={"attributes"})
    public void changeAttributeEditableStatus(@BindingParam(value="attribute") AttributeFormObject attribute) {
        this.referenceDataAttributesEditor.changeAttributeEditableStatus(attribute);
    }

    @Command
    public void updateItemsPaging(int newPageIndex) {
        this.itemsPage = newPageIndex;
        this.notifyChange("itemsPage");
        this.loadItems();
    }

    public String getAttributeValue(AttributeFormObject attribute, SamplingDesignItem item) {
        int fixedColumnsLength = SamplingDesignFileColumn.ALL_COLUMN_NAMES.length;
        int index = attribute.getIndex();
        if (index >= fixedColumnsLength) {
            return item.getInfoAttribute(index - fixedColumnsLength);
        }
        SamplingDesignFileColumn column = SamplingDesignFileColumn.ALL_COLUMNS[index];
        if (column.isLevelColumn()) {
            int level = column.getLevel();
            return item.getLevelCodes().size() >= level ? item.getLevelCode(level) : null;
        }
        if (column == SamplingDesignFileColumn.X) {
            Double value = item.getX();
            return value == null ? null : value.toString();
        }
        if (column == SamplingDesignFileColumn.Y) {
            Double value = item.getY();
            return value == null ? null : value.toString();
        }
        if (column == SamplingDesignFileColumn.SRS_ID) {
            return item.getSrsId();
        }
        return null;
    }

    @Command
    public void openImportPopUp() {
        this.samplingPointDataImportPopUp = SamplingPointDataImportPopUpVM.openPopUp();
    }

    @GlobalCommand
    public void closeSamplingPointDataImportPopUp() {
        SamplingPointDataVM.closePopUp(this.samplingPointDataImportPopUp);
    }

    @GlobalCommand
    public void samplingPointDataUpdated() {
        this.initReferenceDataAttributesEditor();
        this.notifyChange("attributes");
        this.updateItemsPaging(0);
    }

    @Command
    public void exportToCsv() throws IOException {
        this.export(ReferenceDataExportOutputFormat.CSV);
    }

    @Command
    public void exportToExcel() throws IOException {
        this.export(ReferenceDataExportOutputFormat.EXCEL);
    }

    @Command
    public void deleteAllItems() {
        MessageUtil.showConfirm(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                SamplingPointDataVM.this.samplingDesignManager.deleteBySurvey(SamplingPointDataVM.this.getSurveyId().intValue());
                SamplingPointDataVM.this.resetItems();
            }
        }, "survey.sampling_point_data.confirm_delete_all_items");
    }

    private void export(ReferenceDataExportOutputFormat outputFormat) throws IOException {
        SamplingDesignExportJob job = (SamplingDesignExportJob)this.jobManager.createJob(SamplingDesignExportJob.class);
        job.setSurvey(this.getSurvey());
        job.setOutputFormat(outputFormat);
        this.jobManager.start((Job)job, false);
        String mediaType = outputFormat == ReferenceDataExportOutputFormat.CSV ? "text/csv" : "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        String extension = outputFormat.getFileExtesion();
        String fileName = String.format("%s_sampling_point_data_%s.%s", this.getSurvey().getName(), Dates.formatCompactNow(), extension);
        Filedownload.save((InputStream)new FileInputStream(job.getOutputFile()), (String)mediaType, (String)fileName);
    }

    @Command
    public void confirmAttributeUpdate(@BindingParam(value="attribute") AttributeFormObject attribute) {
        if (this.referenceDataAttributesEditor.confirmAttributeUpdate(attribute)) {
            this.dispatchSurveyChangedCommand();
        }
    }

    public List<SamplingDesignItem> getItems() {
        return this.itemsSummaries == null ? null : this.itemsSummaries.getRecords();
    }

    public int getItemsTotal() {
        return this.itemsSummaries == null ? 0 : this.itemsSummaries.getTotalCount();
    }

    public int getItemsPage() {
        return this.itemsPage;
    }

    public int getItemsPageSize() {
        return 20;
    }

    @DependsOn(value={"itemsTotal"})
    public boolean isSamplingPointDataEmpty() {
        return this.getItemsTotal() == 0;
    }

    private void initReferenceDataAttributesEditor() {
        ReferenceDataSchema.SamplingPointDefinition samplingPointDefinition = this.getSurvey().getReferenceDataSchema().getSamplingPointDefinition();
        this.referenceDataAttributesEditor = new ReferenceDataAttributesEditor(Arrays.asList(SamplingDesignFileColumn.ALL_COLUMN_NAMES), (ReferenceDataSchema.ReferenceDataDefinition)samplingPointDefinition);
    }

    private void loadItems() {
        this.itemsSummaries = this.samplingDesignManager.loadBySurvey(this.getSurveyId().intValue(), this.itemsPage * 20, 20);
        this.notifyChange("itemsTotal", "items");
    }

    private void resetItems() {
        this.itemsSummaries = null;
        this.itemsPage = 0;
        this.notifyChange("itemsTotal", "items", "itemsPage");
    }

    public static void notifySamplingPointDataUpdated() {
        BindUtils.postGlobalCommand(null, null, (String)SAMPLING_POINT_DATA_UPDATED_COMMAND, null);
    }

    public static void dispatchSamplingPointDataImportPopUpCloseCommand() {
        BindUtils.postGlobalCommand(null, null, (String)CLOSE_SAMPLING_POINT_DATA_IMPORT_POPUP_COMMAND, null);
    }
}

