/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.metamodel.ui.UITabSet;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.VersionableSurveyObject;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.annotation.AfterCompose;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;

public class EditableListOfNodesVM
extends BaseVM {
    private UITab tab;
    private List<NodeDefinition> nodes;

    @Init
    public void init(@ExecutionArgParam(value="tab") UITab tab, @ExecutionArgParam(value="nodes") List<NodeDefinition> nodes) {
        this.tab = tab;
        this.nodes = nodes;
    }

    @AfterCompose
    public void afterCompose(@ContextParam(value=ContextType.VIEW) Component view) {
        Selectors.wireComponents((Component)view, (Object)this, (boolean)false);
        Selectors.wireEventListeners((Component)view, (Object)this);
    }

    @Listen(value="onDrop = listbox#listOfNodesListbox")
    public void listOfNodesDropHandler(DropEvent evt) {
        Treeitem draggedTreeItem;
        TreeNode value;
        Object data;
        Component dragged = evt.getDragged();
        if (dragged instanceof Treeitem && (data = (value = (TreeNode)(draggedTreeItem = (Treeitem)dragged).getValue()).getData()) instanceof NodeDefinition) {
            NodeDefinition nodeDefn = (NodeDefinition)data;
            UIOptions uiOpts = this.getUIOptions();
            if (uiOpts.isAssignableTo(nodeDefn, this.tab)) {
                UITab oldTab = uiOpts.getAssignedTab(nodeDefn);
                uiOpts.assignToTab(nodeDefn, this.tab);
                HashMap<String, UITab> args = new HashMap<String, UITab>();
                args.put("oldTab", oldTab);
                args.put("newTab", this.tab);
                BindUtils.postGlobalCommand(null, null, (String)"nodeAssignedToTab", args);
            } else {
                MessageUtil.showWarning("survey.layout.cannot_add_node_to_tab", new Object[0]);
            }
        }
    }

    public boolean isEntity(NodeDefinition nodeDefn) {
        return nodeDefn instanceof EntityDefinition;
    }

    public boolean isTabInherited(NodeDefinition nodeDefn) {
        UIOptions uiOpts = this.getUIOptions();
        UITab tab = uiOpts.getAssignedTab(nodeDefn, false);
        return tab != null;
    }

    @Command
    @NotifyChange(value={"nodesPerTab"})
    public void setLayout(@BindingParam(value="type") String type, @BindingParam(value="node") EntityDefinition node) {
        UIOptions uiOpts = this.getUIOptions();
        UIOptions.Layout layout = UIOptions.Layout.valueOf((String)type);
        uiOpts.setLayout(node, layout);
    }

    @GlobalCommand
    public void tabChanged(@BindingParam(value="tab") UITabSet tab) {
        if (tab.equals((Object)this.tab)) {
            BindUtils.postNotifyChange(null, null, (Object)this, (String)"tab");
        }
    }

    public String getTemplateName(NodeDefinition nodeDefn) {
        if (nodeDefn instanceof EntityDefinition) {
            if (nodeDefn.isMultiple()) {
                UIOptions uiOpts = this.getUIOptions();
                UIOptions.Layout layout = uiOpts.getLayout((EntityDefinition)nodeDefn);
                switch (layout) {
                    case FORM: {
                        return "multiple_entity_form";
                    }
                }
                return "multiple_entity_table";
            }
            return "entity";
        }
        return "attribute";
    }

    public boolean hasLayout(EntityDefinition entityDefn, String layout) {
        UIOptions uiOpts = this.getUIOptions();
        UIOptions.Layout nodeLayout = uiOpts.getLayout(entityDefn);
        return nodeLayout.name().equals(layout);
    }

    public List<NodeDefinition> getChildDefinitions(EntityDefinition entityDefn) {
        ArrayList<NodeDefinition> result = new ArrayList<NodeDefinition>();
        List childDefinitions = entityDefn.getChildDefinitions();
        ModelVersion formVersion = this.getLayoutFormVersion();
        for (NodeDefinition nodeDefn : childDefinitions) {
            if (formVersion != null && !formVersion.isApplicable((VersionableSurveyObject)nodeDefn)) continue;
            result.add(nodeDefn);
        }
        return childDefinitions;
    }

    public List<NodeDefinition> getChildDefinitionsInTab(EntityDefinition entityDefn) {
        UIOptions uiOpts = this.getUIOptions();
        List childDefinitions = entityDefn.getChildDefinitions();
        ArrayList<NodeDefinition> result = new ArrayList<NodeDefinition>();
        ModelVersion formVersion = this.getLayoutFormVersion();
        for (NodeDefinition nodeDefn : childDefinitions) {
            UITab nodeTab;
            if (formVersion != null && !formVersion.isApplicable((VersionableSurveyObject)nodeDefn) || (nodeTab = uiOpts.getAssignedTab(nodeDefn)) != this.tab) continue;
            result.add(nodeDefn);
        }
        return result;
    }

    protected CollectSurvey getSurvey() {
        SessionStatus sessionStatus = super.getSessionStatus();
        CollectSurvey survey = sessionStatus.getSurvey();
        return survey;
    }

    protected UIOptions getUIOptions() {
        CollectSurvey survey = this.getSurvey();
        UIOptions uiOpts = survey.getUIOptions();
        return uiOpts;
    }

    public ModelVersion getLayoutFormVersion() {
        SessionStatus sessionStatus = this.getSessionStatus();
        ModelVersion version = sessionStatus.getLayoutFormVersion();
        return version;
    }

    public List<NodeDefinition> getNodes() {
        return this.nodes;
    }

    public UITab getTab() {
        return this.tab;
    }

    @DependsOn(value={"tab"})
    public List<UITab> getTabs() {
        return this.tab != null ? this.tab.getTabs() : null;
    }
}

