/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.collectearth;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.earth.app.server.AbstractPlacemarkDataController;
import org.openforis.collect.earth.app.server.PlacemarkUpdateRequest;
import org.openforis.collect.io.metadata.collectearth.balloon.CollectEarthBalloonGenerator;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CollectEarthBalloonPreviewController
extends AbstractPlacemarkDataController {
    @Autowired
    @Qualifier(value="sessionManager")
    private SessionManager sessionManager;
    @Autowired
    private SurveyManager surveyManager;

    @GetMapping(value={"/preview_placemark-info-expanded"})
    public void placemarkInfoExpanded(@RequestParam(value="id") String placemarkId, HttpServletResponse response) throws IOException {
        CollectSurvey survey = this.sessionManager.getActiveDesignerSurvey();
        this.earthSurveyService.setCollectSurvey(survey);
        super.placemarkInfoExpanded(placemarkId, response);
    }

    @PostMapping(value={"/preview_save-data-expanded"})
    public void saveDataExpanded(PlacemarkUpdateRequest updateRequest, HttpServletResponse response) throws IOException {
        super.saveDataExpanded(updateRequest, response);
    }

    @GetMapping(value={"/collectearthpreview.html"})
    public void showCollectEarthBalloonPreview(HttpServletResponse response, @RequestParam(value="surveyId") Integer surveyId, @RequestParam(value="lang") String languageCode) throws IOException {
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId.intValue());
        CollectEarthBalloonGenerator generator = new CollectEarthBalloonGenerator(survey, languageCode, true);
        String html = generator.generateHTML();
        html = html.replace("earth.js", "earth_new.js");
        this.writeHtmlToResponse(response, html);
    }

    private void writeHtmlToResponse(HttpServletResponse response, String html) throws IOException {
        try (PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());){
            response.setContentType("text/html");
            writer.print(html);
            writer.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

