/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openforis.collect.designer.metamodel.AttributeTypeUtils;
import org.openforis.collect.designer.metamodel.NodeType;
import org.openforis.collect.designer.model.CheckType;
import org.openforis.collect.designer.util.ComponentUtil;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.AttributeType;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.validation.Check;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Window;

public class AttributeConversionVM
extends SurveyBaseVM {
    private AttributeDefinition attributeDefinition;
    private AttributeType originalAttributeType;
    private String attributeType;

    public static Window openPopup(final AttributeDefinition attrDefn) {
        HashMap<String, Object> args = new HashMap<String, Object>(){
            {
                this.put("attribute", attrDefn);
            }
        };
        Window popUp = AttributeConversionVM.openPopUp(Resources.Component.ATTRIBUTE_CONVERSION_PARAMETERS_POPUP.getLocation(), true, args);
        popUp.setTitle(Labels.getLabel((String)"survey.schema.convert_node_popup_title", (Object[])new String[]{NodeType.ATTRIBUTE.getLabel(), attrDefn.getName()}));
        return popUp;
    }

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="attribute") AttributeDefinition attrDefn) {
        super.init();
        this.attributeDefinition = attrDefn;
        this.originalAttributeType = AttributeType.valueOf((AttributeDefinition)attrDefn);
    }

    @Command
    public void convert(@ContextParam(value=ContextType.BIND_CONTEXT) BindContext ctx) {
        if (this.validateForm(ctx)) {
            AttributeType type = AttributeTypeUtils.fromLabel(this.attributeType);
            AttributeDefinition convertedAttribute = new AttributeConverter().convert(this.attributeDefinition, type);
            this.dispatchNodeConvertedCommand((NodeDefinition)convertedAttribute);
            Window popUp = ComponentUtil.getClosest(ctx.getComponent(), Window.class);
            AttributeConversionVM.closePopUp(popUp);
        }
    }

    protected boolean validateForm(BindContext ctx) {
        String messageKey = null;
        if (this.attributeType == null) {
            messageKey = "survey.schema.node.conversion.select_type";
        }
        if (messageKey == null) {
            return true;
        }
        MessageUtil.showWarning(messageKey, new Object[0]);
        return false;
    }

    public List<String> getAttributeTypes() {
        AttributeType currentType = AttributeType.valueOf((AttributeDefinition)this.attributeDefinition);
        AttributeType[] types = AttributeType.values();
        ArrayList<String> typeLabels = new ArrayList<String>(types.length);
        for (AttributeType type : types) {
            if (type == currentType) continue;
            typeLabels.add(AttributeTypeUtils.getLabel(type));
        }
        return typeLabels;
    }

    public String getOriginalAttributeTypeLabel() {
        return AttributeTypeUtils.getLabel(this.originalAttributeType);
    }

    public AttributeDefinition getAttributeDefinition() {
        return this.attributeDefinition;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(String attributeType) {
        this.attributeType = attributeType;
    }

    private static class AttributeConverter {
        private AttributeConverter() {
        }

        public AttributeDefinition convert(AttributeDefinition attrDef, AttributeType toType) {
            int id = attrDef.getId();
            EntityDefinition parentEntityDef = attrDef.getParentEntityDefinition();
            int index = parentEntityDef.getChildDefinitionIndex((NodeDefinition)attrDef);
            AttributeDefinition newAttrDef = (AttributeDefinition)NodeType.createNodeDefinition(attrDef.getSurvey(), NodeType.ATTRIBUTE, toType, id);
            parentEntityDef.removeChildDefinition((NodeDefinition)attrDef);
            newAttrDef.setAnnotations(attrDef.getAnnotations());
            newAttrDef.setAttributeDefaults(attrDef.getAttributeDefaults());
            newAttrDef.setCalculated(attrDef.isCalculated());
            newAttrDef.setKey(attrDef.isKey());
            newAttrDef.setDeprecatedVersion(attrDef.getDeprecatedVersion());
            newAttrDef.setDescriptions(attrDef.getDescriptions());
            newAttrDef.setLabels(attrDef.getLabels());
            newAttrDef.setMaxCountExpression(attrDef.getMinCountExpression());
            newAttrDef.setMinCountExpression(attrDef.getMinCountExpression());
            newAttrDef.setName(attrDef.getName());
            newAttrDef.setMultiple(attrDef.isMultiple());
            newAttrDef.setPrompts(attrDef.getPrompts());
            newAttrDef.setRelevantExpression(attrDef.getRelevantExpression());
            newAttrDef.setSinceVersion(attrDef.getSinceVersion());
            for (Check check : attrDef.getChecks()) {
                if (!this.isApplicable(check, toType)) continue;
                newAttrDef.addCheck(check);
            }
            parentEntityDef.addChildDefinition((NodeDefinition)newAttrDef);
            parentEntityDef.moveChildDefinition((NodeDefinition)newAttrDef, index);
            return newAttrDef;
        }

        private boolean isApplicable(Check<?> check, AttributeType type) {
            CheckType checkType = CheckType.valueOf(check);
            List<CheckType> compatibleTypes = CheckType.compatibleValues(type);
            return compatibleTypes.contains((Object)checkType);
        }
    }
}

