/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.validator.FormValidator;
import org.openforis.collect.designer.viewmodel.SurveyFileVM;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SurveyFile;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class SurveyFileFormValidator
extends FormValidator {
    protected static final String SURVEY_MANAGER_ARG = "surveyManager";
    private static final Pattern VALID_FILENAME_PATTERN = Pattern.compile("^[\\w-\\.]+\\.[\\w-]+$");
    private static final String SAIKU_QUERY_FILE_EXTENSION = "saiku";
    private static final Set<String> RESERVED_FILENAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SurveyFile.SurveyFileType.COLLECT_EARTH_AREA_PER_ATTRIBUTE.getFixedFilename(), "balloon.html", "collectEarthCubes.xml.fmt", "kml_template.fmt", "placemark.idm.xml", "project_definition.properties", "README.txt", "test_plots.ced", "earthFiles", "data", "files", "sampling_design", "species", "idml.xml", "info.properties")));

    @Override
    protected void internalValidate(ValidationContext ctx) {
        if (this.validateTypeUniqueness(ctx) && this.validateMultipleFilesAllowedForType(ctx) && this.validateFilenames(ctx)) {
            this.validateFilenamesUniqueness(ctx);
        }
    }

    private boolean validateMultipleFilesAllowedForType(ValidationContext ctx) {
        String[] filenames = this.getFilenames(ctx);
        if (filenames.length == 1) {
            return true;
        }
        String typeName = (String)this.getValue(ctx, "type");
        SurveyFile.SurveyFileType type = SurveyFile.SurveyFileType.valueOf((String)typeName);
        switch (type) {
            case SURVEY_GUIDE: 
            case COLLECT_EARTH_AREA_PER_ATTRIBUTE: 
            case COLLECT_EARTH_EE_SCRIPT: {
                this.addInvalidMessage(ctx, "type", Labels.getLabel((String)"survey.file.error.multiple_files_not_allowed_for_type"));
                return false;
            }
        }
        return true;
    }

    private boolean validateTypeUniqueness(ValidationContext ctx) {
        List<SurveyFile> otherSurveyFiles = this.loadSurveyFilesDifferentFromThis(ctx);
        String typeName = (String)this.getValue(ctx, "type");
        SurveyFile.SurveyFileType type = SurveyFile.SurveyFileType.valueOf((String)typeName);
        switch (type) {
            case SURVEY_GUIDE: 
            case COLLECT_EARTH_AREA_PER_ATTRIBUTE: 
            case COLLECT_EARTH_EE_SCRIPT: {
                if (this.containsFileWithType(otherSurveyFiles, type)) {
                    this.addInvalidMessage(ctx, "type", Labels.getLabel((String)"survey.file.error.type_already_defined"));
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private String[] getFilenames(ValidationContext ctx) {
        String filenamesStr = (String)this.getValue(ctx, "filenames");
        if (StringUtils.isBlank((CharSequence)filenamesStr)) {
            return new String[0];
        }
        return filenamesStr.split("\n");
    }

    private boolean validateFilenames(ValidationContext ctx) {
        if (this.validateRequired(ctx, "filenames")) {
            for (String filename : this.getFilenames(ctx)) {
                if (this.validateFilenamePattern(ctx, filename)) continue;
                return false;
            }
            return this.validateFilenamesUniqueness(ctx);
        }
        return false;
    }

    private boolean validateFilenamePattern(ValidationContext ctx, String filename) {
        if (!this.validateRegExValue(ctx, VALID_FILENAME_PATTERN, filename, "filenames", "survey.file.error.invalid_filename")) {
            return false;
        }
        String typeName = (String)this.getValue(ctx, "type");
        SurveyFile.SurveyFileType type = SurveyFile.SurveyFileType.valueOf((String)typeName);
        switch (type) {
            case COLLECT_EARTH_AREA_PER_ATTRIBUTE: {
                String expectedFileName = SurveyFile.SurveyFileType.COLLECT_EARTH_AREA_PER_ATTRIBUTE.getFixedFilename();
                if (expectedFileName.equals(filename)) {
                    return true;
                }
                String message = Labels.getLabel((String)"survey.file.error.unexpected_filename", (Object[])new String[]{expectedFileName});
                this.addInvalidMessage(ctx, message);
                return false;
            }
            case COLLECT_EARTH_SAIKU_QUERY: {
                String extension = FilenameUtils.getExtension((String)filename);
                if (SAIKU_QUERY_FILE_EXTENSION.equalsIgnoreCase(extension)) {
                    return true;
                }
                String message = Labels.getLabel((String)"survey.file.error.invalid_extension", (Object[])new String[]{SAIKU_QUERY_FILE_EXTENSION, extension});
                this.addInvalidMessage(ctx, "filenames", message);
                return false;
            }
        }
        if (RESERVED_FILENAMES.contains(filename)) {
            this.addInvalidMessage(ctx, "filenames", Labels.getLabel((String)"survey.file.error.reserved_filename"));
            return false;
        }
        return true;
    }

    private boolean validateFilenamesUniqueness(ValidationContext ctx) {
        List<SurveyFile> otherSurveyFiles = this.loadSurveyFilesDifferentFromThis(ctx);
        String filenames = (String)this.getValue(ctx, "filenames");
        List<String> filenamesList = Arrays.asList(filenames.split("\n"));
        for (SurveyFile surveyFile : otherSurveyFiles) {
            if (!filenamesList.contains(surveyFile.getFilename())) continue;
            this.addInvalidMessage(ctx, "filenames", Labels.getLabel((String)"survey.file.error.duplicate_filename"));
            return false;
        }
        return true;
    }

    private List<SurveyFile> loadSurveyFilesDifferentFromThis(ValidationContext ctx) {
        ArrayList<SurveyFile> result = new ArrayList<SurveyFile>();
        SurveyFileVM vm = (SurveyFileVM)this.getVM(ctx);
        CollectSurvey survey = vm.getSurvey();
        SurveyManager surveyManager = this.getSurveyManager(ctx);
        List surveyFiles = surveyManager.loadSurveyFileSummaries(survey);
        SurveyFile editedSurveyFile = (SurveyFile)vm.getEditedItem();
        for (SurveyFile surveyFile : surveyFiles) {
            if (((Integer)surveyFile.getId()).equals(editedSurveyFile.getId())) continue;
            result.add(surveyFile);
        }
        return result;
    }

    private boolean containsFileWithType(List<SurveyFile> files, SurveyFile.SurveyFileType type) {
        for (SurveyFile surveyFile : files) {
            if (type != surveyFile.getType()) continue;
            return true;
        }
        return false;
    }

    protected SurveyManager getSurveyManager(ValidationContext ctx) {
        return (SurveyManager)ctx.getValidatorArg(SURVEY_MANAGER_ARG);
    }
}

