/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DbUtils {
    public static final String DB_JNDI_RESOURCE_NAME = "jdbc/collectDs";
    public static final String SCHEMA_NAME = "collect";
    private static final Logger LOG = LogManager.getLogger(DbUtils.class);

    public static Connection getConnection() {
        try {
            DataSource datasource = DbUtils.getDataSource();
            return datasource.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DataSource getDataSource() {
        try {
            DataSource ds;
            InitialContext initCtx = new InitialContext();
            try {
                ds = DbUtils.lookupDataSource(initCtx);
                LOG.info("Data source found in initial context with name jdbc/collectDs");
            }
            catch (NamingException e) {
                Context envCtx = (Context)initCtx.lookup("java:comp/env");
                ds = DbUtils.lookupDataSource(envCtx);
                LOG.info("Data source found in environment context with name java:comp/envjdbc/collectDs");
            }
            return ds;
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    private static DataSource lookupDataSource(Context ctx) throws NamingException {
        return (DataSource)ctx.lookup(DB_JNDI_RESOURCE_NAME);
    }

    public static void closeQuietly(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

