/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openforis.collect.designer.form.ModelVersionFormObject;
import org.openforis.collect.designer.form.SurveyObjectFormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.SurveyErrorsPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyObjectPopUpVM;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.VersionableSurveyObject;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.Init;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Window;

public class VersioningVM
extends SurveyObjectPopUpVM<ModelVersion> {
    @WireVariable
    private SurveyManager surveyManager;
    private Window confirmDeletePopUp;

    @Override
    @Init(superclass=false)
    public void init() {
        super.init();
    }

    @Override
    protected List<ModelVersion> getItemsInternal() {
        CollectSurvey survey = this.getSurvey();
        List versions = survey.getSortedVersions();
        return versions;
    }

    @Override
    protected ModelVersion createItemInstance() {
        ModelVersion instance = this.survey.createModelVersion();
        return instance;
    }

    @Override
    protected void addNewItemToSurvey() {
        CollectSurvey survey = this.getSurvey();
        survey.addVersion((ModelVersion)this.editedItem);
    }

    @Override
    protected void deleteItemFromSurvey(ModelVersion item) {
        CollectSurvey survey = this.getSurvey();
        this.surveyManager.removeVersion(survey, item);
        this.dispatchVersionsUpdatedCommand();
    }

    @Command
    public void deleteVersioning(final @BindingParam(value="item") ModelVersion item) {
        List<VersionableSurveyObject> references = this.getReferences(item);
        if (references.isEmpty()) {
            super.deleteItem(item);
        } else {
            String title = Labels.getLabel((String)"survey.versioning.delete.confirm_title");
            String message = Labels.getLabel((String)"survey.versioning.delete.confirm_in_use");
            this.confirmDeletePopUp = SurveyErrorsPopUpVM.openPopUp(title, message, references, new MessageUtil.CompleteConfirmHandler(){

                @Override
                public void onOk() {
                    VersioningVM.this.performDeleteItem(item);
                    VersioningVM.this.closeConfirmDeletePopUp();
                }

                @Override
                public void onCancel() {
                    VersioningVM.this.closeConfirmDeletePopUp();
                }
            });
        }
    }

    @Override
    protected String getConfirmDeleteMessageKey() {
        return "survey.versioning.delete.confirm_message";
    }

    protected void closeConfirmDeletePopUp() {
        VersioningVM.closePopUp(this.confirmDeletePopUp);
        this.confirmDeletePopUp = null;
    }

    @Override
    protected void moveSelectedItemInSurvey(int indexTo) {
        CollectSurvey survey = this.getSurvey();
        survey.moveVersion((ModelVersion)this.selectedItem, indexTo);
    }

    @Override
    protected SurveyObjectFormObject<ModelVersion> createFormObject() {
        return new ModelVersionFormObject();
    }

    @Override
    @Command
    @NotifyChange(value={"editedItem", "selectedItem"})
    public void applyChanges(@ContextParam(value=ContextType.BINDER) Binder binder) {
        super.applyChanges(binder);
        this.dispatchVersionsUpdatedCommand();
    }

    protected List<VersionableSurveyObject> getReferences(ModelVersion version) {
        List<VersionableSurveyObject> referencesInSchema = this.getReferencesInSchema(version);
        List<VersionableSurveyObject> referencesInCodeLists = this.getReferencesInCodeLists(version);
        ArrayList<VersionableSurveyObject> result = new ArrayList<VersionableSurveyObject>();
        result.addAll(referencesInSchema);
        result.addAll(referencesInCodeLists);
        return result;
    }

    protected List<VersionableSurveyObject> getReferencesInSchema(ModelVersion version) {
        ArrayList<VersionableSurveyObject> references = new ArrayList<VersionableSurveyObject>();
        Schema schema = this.survey.getSchema();
        List rootEntities = schema.getRootEntityDefinitions();
        Stack stack = new Stack();
        stack.addAll(rootEntities);
        while (!stack.isEmpty()) {
            NodeDefinition defn = (NodeDefinition)stack.pop();
            if (this.isVersionInUse(version, (VersionableSurveyObject)defn)) {
                references.add((VersionableSurveyObject)defn);
            }
            if (!(defn instanceof EntityDefinition)) continue;
            stack.addAll(((EntityDefinition)defn).getChildDefinitions());
        }
        return references;
    }

    protected List<VersionableSurveyObject> getReferencesInCodeLists(ModelVersion version) {
        ArrayList<VersionableSurveyObject> references = new ArrayList<VersionableSurveyObject>();
        List codeLists = this.survey.getCodeLists();
        for (CodeList codeList : codeLists) {
            if (this.isVersionInUse(version, (VersionableSurveyObject)codeList)) {
                references.add((VersionableSurveyObject)codeList);
            }
            if (codeList.isExternal()) continue;
            List items = codeList.getItems();
            Stack itemsStack = new Stack();
            itemsStack.addAll(items);
            while (!itemsStack.isEmpty()) {
                CodeListItem item = (CodeListItem)itemsStack.pop();
                if (this.isVersionInUse(version, (VersionableSurveyObject)item)) {
                    references.add((VersionableSurveyObject)item);
                }
                itemsStack.addAll(item.getChildItems());
            }
        }
        return references;
    }

    protected boolean isVersionInUse(ModelVersion version, VersionableSurveyObject object) {
        ModelVersion sinceVersion = object.getSinceVersion();
        ModelVersion deprecatedVersion = object.getDeprecatedVersion();
        return version.equals((Object)sinceVersion) || version.equals((Object)deprecatedVersion);
    }

    private void dispatchVersionsUpdatedCommand() {
        BindUtils.postGlobalCommand(null, null, (String)"versionsUpdated", null);
    }

    @Override
    protected void dispatchChangesAppliedCommand(boolean ignoreUnsavedChanges) {
        this.postCloseVersioningManagerPopUpCommand();
    }

    @Override
    protected void dispatchChangesCancelledCommand() {
        this.postCloseVersioningManagerPopUpCommand();
    }

    private void postCloseVersioningManagerPopUpCommand() {
        BindUtils.postGlobalCommand(null, null, (String)"closeVersioningManagerPopUp", null);
    }
}

