/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.KmlFactory;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openforis.collect.manager.SamplingDesignManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.CollectSurveyContext;
import org.openforis.collect.model.LngLat;
import org.openforis.collect.model.SamplingDesignItem;
import org.openforis.collect.model.SamplingDesignSummaries;
import org.openforis.commons.lang.Strings;
import org.openforis.idm.geospatial.CoordinateOperations;
import org.openforis.idm.model.Coordinate;

public class SamplingPointDataKmlGenerator {
    private SamplingDesignManager samplingDesignManager;
    private CollectSurvey survey;
    private Kml kml;

    public SamplingPointDataKmlGenerator(SamplingDesignManager samplingDesignManager, CollectSurvey survey) {
        this.samplingDesignManager = samplingDesignManager;
        this.survey = survey;
    }

    public void generate() {
        Kml kml = KmlFactory.createKml();
        Document doc = kml.createAndSetDocument();
        List<SamplingDesignItem> samplingDesignItems = this.loadSamplingDesignItems();
        for (SamplingDesignItem item : samplingDesignItems) {
            Coordinate coordinate = new Coordinate(item.getX(), item.getY(), item.getSrsId());
            LngLat lngLatAlt = this.createLngLat(coordinate);
            doc.createAndAddPlacemark().withName(Strings.joinNotBlank((Collection)item.getLevelCodes(), (String)"|")).withOpen(Boolean.valueOf(true)).createAndSetPoint().addToCoordinates(lngLatAlt.getLongitude().doubleValue(), lngLatAlt.getLatitude().doubleValue());
        }
        this.kml = kml;
    }

    public void write(OutputStream output) {
        if (this.kml == null) {
            throw new IllegalStateException("KML not generated yet: call 'generate' first");
        }
        try {
            this.kml.marshal(output);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Fail to generate KML for survey %s Sampling Point Data: %s", this.survey.getName(), e.getMessage()), e);
        }
    }

    private List<SamplingDesignItem> loadSamplingDesignItems() {
        SamplingDesignSummaries samplingDesignSummaries = this.samplingDesignManager.loadBySurvey(this.survey.getId().intValue());
        List samplingDesignItems = samplingDesignSummaries.getRecords();
        ArrayList<SamplingDesignItem> result = new ArrayList<SamplingDesignItem>();
        for (SamplingDesignItem item : samplingDesignItems) {
            result.add(item);
        }
        return result;
    }

    private LngLat createLngLat(Coordinate coord) {
        try {
            CollectSurveyContext surveyContext = (CollectSurveyContext)this.survey.getContext();
            CoordinateOperations coordOpts = surveyContext.getCoordinateOperations();
            Coordinate wgs84Coord = coordOpts.convertToWgs84(coord);
            return new LngLat(wgs84Coord.getX(), wgs84Coord.getY());
        }
        catch (Exception e) {
            return null;
        }
    }
}

