/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.manager;

import java.util.List;
import java.util.Set;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.manager.DataCleansingChainManager;
import org.openforis.collect.datacleansing.manager.DataQueryManager;
import org.openforis.collect.datacleansing.persistence.DataCleansingStepDao;
import org.openforis.collect.manager.AbstractSurveyObjectManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DataCleansingStepManager
extends AbstractSurveyObjectManager<Integer, DataCleansingStep, DataCleansingStepDao> {
    @Autowired
    private DataQueryManager dataQueryManager;
    @Autowired
    private DataCleansingChainManager dataCleansingChainManager;

    @Transactional
    public void delete(DataCleansingStep step) {
        Set<DataCleansingChain> chainsUsingStep = this.dataCleansingChainManager.loadByStep(step);
        if (!chainsUsingStep.isEmpty()) {
            throw new IllegalStateException(String.format("Cannote delete step with id %d: some chains are associated to it", step.getId()));
        }
        ((DataCleansingStepDao)this.dao).deleteStepValues((Integer)step.getId());
        super.delete((PersistedSurveyObject)step);
    }

    public void deleteBySurvey(CollectSurvey survey) {
        ((DataCleansingStepDao)this.dao).deleteStepValues(survey);
        super.deleteBySurvey(survey);
    }

    public List<DataCleansingStep> loadByQuery(DataQuery query) {
        List<DataCleansingStep> steps = ((DataCleansingStepDao)this.dao).loadByQuery(query);
        this.initializeItems(steps);
        return steps;
    }

    protected void initializeItem(DataCleansingStep i) {
        super.initializeItem((PersistedSurveyObject)i);
        this.initializeQuery(i);
    }

    @Transactional
    public DataCleansingStep save(DataCleansingStep step, User activeUser) {
        super.save((PersistedSurveyObject)step, activeUser);
        ((DataCleansingStepDao)this.dao).deleteStepValues((Integer)step.getId());
        if (step.getType() == DataCleansingStep.DataCleansingStepType.ATTRIBUTE_UPDATE && !step.getUpdateValues().isEmpty()) {
            ((DataCleansingStepDao)this.dao).insertStepValues((Integer)step.getId(), step.getUpdateValues());
        }
        return step;
    }

    private void initializeQuery(DataCleansingStep step) {
        DataQuery query = (DataQuery)this.dataQueryManager.loadById((CollectSurvey)step.getSurvey(), step.getQueryId());
        step.setQuery(query);
    }
}

