/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.persistence;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableLike;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryGroup;
import org.openforis.collect.datacleansing.persistence.DataCleansingItemDao;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.persistence.jooq.CollectDSLContext;
import org.openforis.collect.persistence.jooq.Sequences;
import org.openforis.collect.persistence.jooq.SurveyObjectMappingDSLContext;
import org.openforis.collect.persistence.jooq.tables.OfcDataQueryGroup;
import org.openforis.collect.persistence.jooq.tables.OfcDataQueryGroupQuery;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dataQueryGroupDao")
@Transactional
public class DataQueryGroupDao
extends DataCleansingItemDao<DataQueryGroup, JooqDSLContext> {
    public DataQueryGroupDao() {
        super(JooqDSLContext.class);
    }

    public List<DataQueryGroup> loadBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectSeekStep1 select = dsl.selectFrom((Table)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP).where(new Condition[]{OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.SURVEY_ID.eq((Object)survey.getId())}).orderBy((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.TITLE);
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    public void deleteBySurvey(CollectSurvey survey) {
        ((JooqDSLContext)this.dsl()).deleteFrom((Table)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP).where(new Condition[]{OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.SURVEY_ID.eq((Object)survey.getId())}).execute();
    }

    public Set<DataQueryGroup> loadGroupsByQuery(DataQuery query) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)query.getSurvey());
        SelectConditionStep subselect = dsl.select((SelectField)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.GROUP_ID).from((TableLike)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY).where(new Condition[]{OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.QUERY_ID.eq((Object)((Integer)query.getId()))});
        SelectConditionStep select = dsl.selectFrom((Table)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP).where(new Condition[]{OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.ID.in((Select)subselect)});
        Result result = select.fetch();
        return new HashSet<DataQueryGroup>(dsl.fromResult(result));
    }

    public List<Integer> loadQueryIds(DataQueryGroup group) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)group.getSurvey());
        SelectSeekStep1 select = dsl.select((SelectField)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.QUERY_ID).from((TableLike)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY).where(new Condition[]{OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.GROUP_ID.eq((Object)((Integer)group.getId()))}).orderBy((Field)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.SORT_ORDER);
        List ids = select.fetch((Field)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.QUERY_ID);
        return ids;
    }

    public void deleteQueryAssociations(DataQueryGroup group) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)group.getSurvey());
        dsl.delete((Table)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY).where(new Condition[]{OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.GROUP_ID.eq((Object)((Integer)group.getId()))}).execute();
    }

    public void deleteQueryAssociations(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        dsl.delete((Table)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY).where(new Condition[]{OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.GROUP_ID.in(DataQueryGroupDao.createDataQueryGroupIdBySurveyQuery((CollectDSLContext)dsl, survey))}).execute();
    }

    public void insertQueryAssociations(DataQueryGroup chain, List<Integer> queryIds) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)chain.getSurvey());
        BatchBindStep batch = dsl.batch((Query)dsl.insertInto((Table)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY, (Field)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.GROUP_ID, (Field)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.QUERY_ID, (Field)OfcDataQueryGroupQuery.OFC_DATA_QUERY_GROUP_QUERY.SORT_ORDER).values((Object)null, (Object)null, (Object)null));
        int position = 0;
        for (Integer stepId : queryIds) {
            batch.bind(new Object[]{chain.getId(), stepId, position++});
        }
        batch.execute();
    }

    protected static SelectConditionStep<Record1<Integer>> createDataQueryGroupIdBySurveyQuery(CollectDSLContext dsl, CollectSurvey survey) {
        return dsl.select((SelectField)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.ID).from((TableLike)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP).where(new Condition[]{OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.SURVEY_ID.eq((Object)survey.getId())});
    }

    protected static class JooqDSLContext
    extends SurveyObjectMappingDSLContext<Integer, DataQueryGroup> {
        private static final long serialVersionUID = 1L;

        public JooqDSLContext(Configuration config) {
            this(config, null);
        }

        public JooqDSLContext(Configuration config, CollectSurvey survey) {
            super(config, OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.ID, Sequences.OFC_DATA_QUERY_GROUP_ID_SEQ, DataQueryGroup.class, survey);
        }

        protected DataQueryGroup newEntity() {
            return new DataQueryGroup(this.getSurvey());
        }

        protected void fromRecord(Record r, DataQueryGroup o) {
            super.fromRecord(r, (PersistedSurveyObject)o);
            o.setCreationDate((Date)r.getValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.CREATION_DATE));
            o.setDescription((String)r.getValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.DESCRIPTION));
            o.setModifiedDate((Date)r.getValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.MODIFIED_DATE));
            o.setTitle((String)r.getValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.TITLE));
            o.setUuid(UUID.fromString((String)r.getValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.UUID)));
        }

        protected void fromObject(DataQueryGroup o, StoreQuery<?> q) {
            super.fromObject((PersistedSurveyObject)o, q);
            q.addValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.CREATION_DATE, (Object)DataQueryGroupDao.toTimestamp((Date)o.getCreationDate()));
            q.addValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.DESCRIPTION, (Object)o.getDescription());
            q.addValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.MODIFIED_DATE, (Object)DataQueryGroupDao.toTimestamp((Date)o.getModifiedDate()));
            q.addValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.SURVEY_ID, (Object)o.getSurvey().getId());
            q.addValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.TITLE, (Object)o.getTitle());
            q.addValue((Field)OfcDataQueryGroup.OFC_DATA_QUERY_GROUP.UUID, (Object)o.getUuid().toString());
        }
    }
}

