/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.designer.form.AttributeDefinitionFormObject;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.TaxonAttributeDefinition;
import org.openforis.idm.model.species.Taxon;

public class TaxonAttributeDefinitionFormObject
extends AttributeDefinitionFormObject<TaxonAttributeDefinition> {
    private String taxonomy;
    private String highestRank;
    private List<String> qualifiers;
    private Boolean includeUniqueVernacularName = (Boolean)CollectAnnotations.Annotation.TAXON_ATTRIBUTE_INCLUDE_UNIQUE_VERNACULAR_NAME.getDefaultValue();
    private Boolean showFamily = (Boolean)CollectAnnotations.Annotation.TAXON_ATTRIBUTE_SHOW_FAMILY.getDefaultValue();
    private String codeFieldLabel;
    private String scientificNameFieldLabel;
    private String vernacularNameFieldLabel;
    private String languageCodeFieldLabel;
    private String languageVarietyFieldLabel;
    private String familyCodeFieldLabel;
    private String familyNameFieldLabel;
    private boolean allowUnlisted;

    TaxonAttributeDefinitionFormObject(EntityDefinition parentDefn) {
        super(parentDefn);
    }

    @Override
    public void loadFrom(TaxonAttributeDefinition source, String languageCode) {
        super.loadFrom(source, languageCode);
        this.taxonomy = source.getTaxonomy();
        this.highestRank = source.getHighestTaxonRank() == null ? null : source.getHighestTaxonRank().getName();
        this.qualifiers = new ArrayList<String>(source.getQualifiers());
        CollectSurvey survey = (CollectSurvey)source.getSurvey();
        CollectAnnotations annotations = survey.getAnnotations();
        this.showFamily = annotations.isShowFamily(source);
        this.includeUniqueVernacularName = annotations.isIncludeUniqueVernacularName(source);
        this.allowUnlisted = annotations.isAllowUnlisted(source);
        this.codeFieldLabel = source.getFieldLabel("code", languageCode);
        this.scientificNameFieldLabel = source.getFieldLabel("scientific_name", languageCode);
        this.vernacularNameFieldLabel = source.getFieldLabel("vernacular_name", languageCode);
        this.languageCodeFieldLabel = source.getFieldLabel("language_code", languageCode);
        this.languageVarietyFieldLabel = source.getFieldLabel("language_variety", languageCode);
        this.familyCodeFieldLabel = source.getFieldLabel("family_code", languageCode);
        this.familyNameFieldLabel = source.getFieldLabel("family_scientific_name", languageCode);
    }

    @Override
    public void saveTo(TaxonAttributeDefinition dest, String languageCode) {
        super.saveTo(dest, languageCode);
        dest.setTaxonomy(this.taxonomy);
        dest.setHighestTaxonRank(Taxon.TaxonRank.fromName((String)this.highestRank));
        dest.setQualifiers(this.qualifiers);
        dest.setFieldLabel("code", languageCode, this.codeFieldLabel);
        dest.setFieldLabel("scientific_name", languageCode, this.scientificNameFieldLabel);
        dest.setFieldLabel("vernacular_name", languageCode, this.vernacularNameFieldLabel);
        dest.setFieldLabel("language_code", languageCode, this.languageCodeFieldLabel);
        dest.setFieldLabel("language_variety", languageCode, this.languageVarietyFieldLabel);
        dest.setFieldLabel("family_code", languageCode, this.familyCodeFieldLabel);
        dest.setFieldLabel("family_scientific_name", languageCode, this.familyNameFieldLabel);
        CollectSurvey survey = (CollectSurvey)dest.getSurvey();
        CollectAnnotations annotations = survey.getAnnotations();
        annotations.setShowFamily(dest, this.showFamily.booleanValue());
        annotations.setIncludeUniqueVernacularName(dest, this.includeUniqueVernacularName.booleanValue());
        annotations.setAllowUnlisted(dest, this.allowUnlisted);
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public void setTaxonomy(String taxonomy) {
        this.taxonomy = taxonomy;
    }

    public String getHighestRank() {
        return this.highestRank;
    }

    public void setHighestRank(String highestRank) {
        this.highestRank = highestRank;
    }

    public List<String> getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(List<String> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public Boolean getIncludeUniqueVernacularName() {
        return this.includeUniqueVernacularName;
    }

    public void setIncludeUniqueVernacularName(Boolean includeUniqueVernacularName) {
        this.includeUniqueVernacularName = includeUniqueVernacularName;
    }

    public Boolean getShowFamily() {
        return this.showFamily;
    }

    public void setShowFamily(Boolean showFamily) {
        this.showFamily = showFamily;
    }

    public String getCodeFieldLabel() {
        return this.codeFieldLabel;
    }

    public void setCodeFieldLabel(String codeFieldLabel) {
        this.codeFieldLabel = codeFieldLabel;
    }

    public String getScientificNameFieldLabel() {
        return this.scientificNameFieldLabel;
    }

    public void setScientificNameFieldLabel(String scientificNameFieldLabel) {
        this.scientificNameFieldLabel = scientificNameFieldLabel;
    }

    public String getVernacularNameFieldLabel() {
        return this.vernacularNameFieldLabel;
    }

    public void setVernacularNameFieldLabel(String vernacularNameFieldLabel) {
        this.vernacularNameFieldLabel = vernacularNameFieldLabel;
    }

    public String getLanguageCodeFieldLabel() {
        return this.languageCodeFieldLabel;
    }

    public void setLanguageCodeFieldLabel(String languageCodeFieldLabel) {
        this.languageCodeFieldLabel = languageCodeFieldLabel;
    }

    public String getLanguageVarietyFieldLabel() {
        return this.languageVarietyFieldLabel;
    }

    public void setLanguageVarietyFieldLabel(String languageVarietyFieldLabel) {
        this.languageVarietyFieldLabel = languageVarietyFieldLabel;
    }

    public String getFamilyCodeFieldLabel() {
        return this.familyCodeFieldLabel;
    }

    public void setFamilyCodeFieldLabel(String familyCodeFieldLabel) {
        this.familyCodeFieldLabel = familyCodeFieldLabel;
    }

    public String getFamilyNameFieldLabel() {
        return this.familyNameFieldLabel;
    }

    public void setFamilyNameFieldLabel(String familyNameFieldLabel) {
        this.familyNameFieldLabel = familyNameFieldLabel;
    }

    public boolean isAllowUnlisted() {
        return this.allowUnlisted;
    }

    public void setAllowUnlisted(boolean allowUnlisted) {
        this.allowUnlisted = allowUnlisted;
    }
}

