/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserRole;
import org.openforis.collect.model.proxy.BasicUserProxy;

public class UserProxy
extends BasicUserProxy {
    private String password;
    private String rawPassword;
    private List<String> roles;

    public UserProxy(User user) {
        super(user);
        this.roles = user.getRoleCodes();
    }

    @Override
    public User toUser() {
        User user = super.toUser();
        user.setPassword(this.password);
        user.setRawPassword(this.rawPassword);
        user.setRoles(this.getRolesFromCodes(this.roles));
        return user;
    }

    private List<UserRole> getRolesFromCodes(List<String> codes) {
        ArrayList<UserRole> roles = new ArrayList<UserRole>();
        for (String code : codes) {
            UserRole role = UserRole.fromCode((String)code);
            roles.add(role);
        }
        return roles;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRawPassword() {
        return this.rawPassword;
    }

    public void setRawPassword(String rawPassword) {
        this.rawPassword = rawPassword;
    }
}

