/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.geospatial;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.openforis.collect.utils.SurveyObjects;
import org.openforis.idm.geospatial.CoordinateOperationException;
import org.openforis.idm.geospatial.CoordinateOperations;
import org.openforis.idm.metamodel.SpatialReferenceSystem;
import org.openforis.idm.model.Coordinate;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class GeoToolsCoordinateOperations
extends CoordinateOperations {
    private static final Logger LOG = LogManager.getLogger(GeoToolsCoordinateOperations.class);
    private TransformCache transformCache = new TransformCache();
    private Map<String, CoordinateReferenceSystem> CRS_BY_SRS_ID = new HashMap<String, CoordinateReferenceSystem>();

    public void initialize() {
        try {
            this.CRS_BY_SRS_ID.put("EPSG:4326", (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            CoordinateReferenceSystem webMercatorCrs = CRS.decode((String)"EPSG:3857");
            this.CRS_BY_SRS_ID.put("EPSG:3857", webMercatorCrs);
            this.getOrCreateTransform("EPSG:4326", "EPSG:3857");
            this.getOrCreateTransform("EPSG:3857", "EPSG:4326");
        }
        catch (Exception e) {
            LOG.error("Error while initializing CoordinateOperations", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public double orthodromicDistance(Position startingPosition, Position destinationPosition) throws CoordinateOperationException {
        try {
            GeodeticCalculator calculator = new GeodeticCalculator();
            calculator.setStartingPosition(startingPosition);
            calculator.setDestinationPosition(destinationPosition);
            double result = calculator.getOrthodromicDistance();
            return result;
        }
        catch (Exception e) {
            throw new CoordinateOperationException("Failed to determine distance from " + startingPosition + " to " + destinationPosition, (Throwable)e);
        }
    }

    public boolean validate(Coordinate coordinate) {
        try {
            double x = coordinate.getX();
            double y = coordinate.getY();
            String srsId = coordinate.getSrsId();
            Position position = this.toLatLonPosition(x, y, srsId);
            GeodeticCalculator calculator = new GeodeticCalculator();
            calculator.setStartingPosition(position);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void validateWKT(String wkt) throws Exception {
        CRS.parseWKT((String)wkt);
    }

    public double orthodromicDistance(double startX, double startY, String startSRSId, double destX, double destY, String destSRSId) throws CoordinateOperationException {
        Position startingPosition = this.toLatLonPosition(startX, startY, startSRSId);
        Position destinationPosition = this.toLatLonPosition(destX, destY, destSRSId);
        return this.orthodromicDistance(startingPosition, destinationPosition);
    }

    public double orthodromicDistance(Coordinate startingCoordinate, Coordinate destinationCoordinate) throws CoordinateOperationException {
        double startX = startingCoordinate.getX();
        double startY = startingCoordinate.getY();
        String startSRSId = startingCoordinate.getSrsId();
        double destX = destinationCoordinate.getX();
        double destY = destinationCoordinate.getY();
        String destSRSId = destinationCoordinate.getSrsId();
        return this.orthodromicDistance(startX, startY, startSRSId, destX, destY, destSRSId);
    }

    public SpatialReferenceSystem fetchSRS(String code) {
        return this.fetchSRS(code, Collections.singleton("en"));
    }

    public SpatialReferenceSystem fetchSRS(String code, Set<String> labelLanguages) {
        try {
            CRSAuthorityFactory factory = CRS.getAuthorityFactory((boolean)true);
            CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem(code);
            SpatialReferenceSystem result = new SpatialReferenceSystem(code, crs.toWKT());
            String description = this.getDescription(crs);
            for (String lang : labelLanguages) {
                result.setLabel(lang, code);
                result.setDescription(lang, description);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Error fetching SRS with code: " + code, e);
        }
    }

    private String getDescription(CoordinateReferenceSystem crs) {
        ArrayList<String> parts = new ArrayList<String>();
        if (crs instanceof AbstractSingleCRS) {
            Datum datum = ((AbstractSingleCRS)crs).getDatum();
            String datumName = datum.getName().toString();
            parts.add(datumName);
        }
        for (GenericName genericName : crs.getAlias()) {
            parts.add(genericName.toString());
        }
        InternationalString scope = crs.getScope();
        if (scope != null && StringUtils.isNotBlank((CharSequence)scope)) {
            parts.add(scope.toString());
        }
        String result = StringUtils.join(parts, (String)"\n");
        return result;
    }

    public Set<String> getAvailableSRSs() {
        HashSet<String> result = new HashSet<String>();
        String authorityCode = "EPSG";
        String codePrefix = authorityCode + ":";
        Set supportedCodes = CRS.getSupportedCodes((String)authorityCode);
        for (String code : supportedCodes) {
            if (code.startsWith(codePrefix)) {
                result.add(code);
                continue;
            }
            result.add(codePrefix + code);
        }
        return result;
    }

    public void parseSRS(List<SpatialReferenceSystem> srss) {
        this.registerSRS(srss);
    }

    public void parseSRS(SpatialReferenceSystem srs) {
        this.registerSRS(srs);
    }

    public void registerSRS(SpatialReferenceSystem srs) {
        String srsId = srs.getId();
        if (!this.CRS_BY_SRS_ID.containsKey(srsId)) {
            String wkt = srs.getWellKnownText();
            try {
                MathTransform latLonTransform = this.transformCache.get("EPSG:4326", srsId);
                CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
                latLonTransform = GeoToolsCoordinateOperations.findToWGS84MathTransform(crs);
                this.transformCache.put(srsId, "EPSG:4326", latLonTransform);
                CoordinateReferenceSystem webMercatorCrs = this.CRS_BY_SRS_ID.get("EPSG:3857");
                MathTransform webMarcatorTransform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)webMercatorCrs);
                this.transformCache.put(srsId, "EPSG:3857", webMarcatorTransform);
                this.CRS_BY_SRS_ID.put(srsId, crs);
            }
            catch (Exception e) {
                LOG.error(String.format("Error parsing SpatialRefernceSystem with id %s and Well Known Text %s", srsId, wkt), (Throwable)e);
                this.CRS_BY_SRS_ID.put(srsId, null);
            }
        }
    }

    public Coordinate convertToWgs84(Coordinate coordinate) {
        String toSrsId = "EPSG:4326";
        return this.convertTo(coordinate, toSrsId);
    }

    public Coordinate convertTo(Coordinate coordinate, String toSrsId) {
        if (toSrsId.equals(coordinate.getSrsId())) {
            return coordinate;
        }
        Position position = this.toPosition(coordinate.getX(), coordinate.getY(), coordinate.getSrsId(), toSrsId);
        DirectPosition directPosition = position.getDirectPosition();
        return new Coordinate(Double.valueOf(directPosition.getOrdinate(0)), Double.valueOf(directPosition.getOrdinate(1)), toSrsId);
    }

    public Coordinate convertToWebMarcator(Coordinate coordinate) {
        return this.convert(coordinate.getX(), coordinate.getY(), coordinate.getSrsId(), "EPSG:3857");
    }

    public Coordinate fromLatLonToWebMarcator(double lat, double lon) {
        return this.convert(lon, lat, "EPSG:4326", "EPSG:3857");
    }

    private Coordinate convert(double x, double y, String fromSrsId, String toSrsId) {
        try {
            DirectPosition2D src = new DirectPosition2D(x, y);
            MathTransform transform = this.getOrCreateTransform(fromSrsId, toSrsId);
            if (transform == null) {
                LOG.error("Unknown CRS: " + toSrsId);
                return new Coordinate(Double.valueOf(0.0), Double.valueOf(0.0), toSrsId);
            }
            DirectPosition directPosition = transform.transform((DirectPosition)src, null);
            double[] coord = directPosition.getCoordinate();
            return new Coordinate(Double.valueOf(coord[0]), Double.valueOf(coord[1]), toSrsId);
        }
        catch (Throwable t) {
            LOG.error("Error converting lat lon to web marcator: lat=" + y + " lon=" + x, t);
            return new Coordinate(Double.valueOf(0.0), Double.valueOf(0.0), toSrsId);
        }
    }

    private Position toLatLonPosition(double x, double y, String srsId) {
        return this.toPosition(x, y, srsId, "EPSG:4326");
    }

    private Position toPosition(double x, double y, String fromSrsId, String toSrsId) {
        try {
            DirectPosition2D src = new DirectPosition2D(x, y);
            MathTransform transform = this.getOrCreateTransform(fromSrsId, toSrsId);
            if (transform == null) {
                if (LOG.isErrorEnabled()) {
                    String fromSRSIdCleaned = SurveyObjects.adjustInternalName((String)StringUtils.truncate((String)fromSrsId, (int)20));
                    String toSRSIdCleaned = SurveyObjects.adjustInternalName((String)StringUtils.truncate((String)toSrsId, (int)20));
                    LOG.error(String.format("Cannot find transform from %s to %s", fromSRSIdCleaned, toSRSIdCleaned));
                }
                return new DirectPosition2D(0.0, 0.0);
            }
            DirectPosition directPosition = transform.transform((DirectPosition)src, null);
            return directPosition;
        }
        catch (Throwable t) {
            LOG.error("Error converting: x=" + x + " y=" + y + " srs=" + fromSrsId, t);
            return new DirectPosition2D(0.0, 0.0);
        }
    }

    private static MathTransform findToWGS84MathTransform(CoordinateReferenceSystem crs) throws FactoryException {
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        return mathTransform;
    }

    private MathTransform getOrCreateTransform(String fromSrsId, String toSrsId) throws FactoryException {
        MathTransform transform = this.transformCache.get(fromSrsId, toSrsId);
        if (transform == null) {
            CoordinateReferenceSystem fromCRS = this.CRS_BY_SRS_ID.get(fromSrsId);
            CoordinateReferenceSystem toCrs = this.CRS_BY_SRS_ID.get(toSrsId);
            transform = CRS.findMathTransform((CoordinateReferenceSystem)fromCRS, (CoordinateReferenceSystem)toCrs, (boolean)true);
            this.transformCache.put(fromSrsId, toSrsId, transform);
        }
        return transform;
    }

    private static class TransformCache {
        private Map<TransformKey, MathTransform> srsIdToTransforms = new HashMap<TransformKey, MathTransform>();

        private TransformCache() {
        }

        public MathTransform get(String fromSrsId, String toSrsId) {
            return this.srsIdToTransforms.get(new TransformKey(fromSrsId, toSrsId));
        }

        public void put(String fromSrsId, String toSrsId, MathTransform transform) {
            this.srsIdToTransforms.put(new TransformKey(fromSrsId, toSrsId), transform);
        }

        private static class TransformKey {
            private String fromSrsId;
            private String toSrsId;

            public TransformKey(String fromSrsId, String toSrsId) {
                this.fromSrsId = fromSrsId;
                this.toSrsId = toSrsId;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.fromSrsId == null ? 0 : this.fromSrsId.hashCode());
                result = 31 * result + (this.toSrsId == null ? 0 : this.toSrsId.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TransformKey other = (TransformKey)obj;
                if (this.fromSrsId == null ? other.fromSrsId != null : !this.fromSrsId.equals(other.fromSrsId)) {
                    return false;
                }
                return !(this.toSrsId == null ? other.toSrsId != null : !this.toSrsId.equals(other.toSrsId));
            }
        }
    }
}

